<?php
/**
 * CodeBrain BV       https://www.codebrain.nl.
 *
 * @author      CodeBrain B.V. <info@codebrain.nl>
 * @copyright   Codebrain B.V.
 * @license     https://opensource.org/licenses/bsd-license.php
 *
 * @see        https://www.ideal-checkout.nl/
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class IcOmnikassaPaymentModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $display_column_left = false;

    public function postProcess()
    {
        $sPaymentCode = Tools::getValue('payment');

        $oCart = $this->context->cart;

        if (!$this->module->active) {
            Tools::redirect('index.php?controller=order&step=1');
        } elseif ($oCart->id_customer == 0 || $oCart->id_address_delivery == 0 || $oCart->id_address_invoice == 0) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        // Validate Customer
        $oCustomer = new Customer($this->context->cart->id_customer);

        if (!Validate::isLoadedObject($oCustomer)) {
            Tools::redirectLink(__PS_BASE_URI__.'order.php?step=1');
        }

        $sLanguageCode = Context::getContext()->language->iso_code;
        $fAmount = $oCart->getOrderTotal(true, Cart::BOTH);

        $oCurrency = new Currency($oCart->id_currency);
        $sCurrencyCode = $oCurrency->iso_code;

        $sReturnUrl = $this->context->link->getModuleLink($this->module->name, 'return', [], true);
        $sOrderId = $oCart->id;
        $sDescription = Configuration::get('PS_SHOP_NAME').' '.$oCart->id;

        // Init Rabo Smart Pay
        $bSandbox = (bool) Configuration::get('ICROK2_SANDBOX');

        $sRefreshToken = '';
        $sSigningKey = '';

        if ($bSandbox) {
            $sRefreshToken = Configuration::get('ICROK2_REFRESHTOKEN_SANDBOX');
            $sSigningKey = Configuration::get('ICROK2_SIGNINGKEY_SANDBOX');
        } else {
            $sRefreshToken = Configuration::get('ICROK2_REFRESHTOKEN_PRODUCTION');
            $sSigningKey = Configuration::get('ICROK2_SIGNINGKEY_PRODUCTION');
        }

        $oOmnikassa = new OmnikassaPayment($sRefreshToken, $sSigningKey);

        $oOmnikassa->setTestmode($bSandbox);
        $oOmnikassa->setCurrencyCode($sCurrencyCode);
        $oOmnikassa->setOrderAmount((int) round($fAmount * 100));
        $oOmnikassa->setLanguageCode($sLanguageCode);
        $oOmnikassa->setPaymentMethod($sPaymentCode);
        $oOmnikassa->setOrder($sOrderId, $sDescription);
        $oOmnikassa->setReturnUrl($sReturnUrl);

        if($sPaymentCode === 'cards' && Configuration::get('ICROK2_COF')) {
            // Check if customer is logged in
            if ($this->context->customer->isLogged()) {
                $oOmnikassa->setShopperRef($oCustomer->id);

                $oOmnikassa->enableCof(true);
            }
        }

        // Set additional data
        $customer = [];

        $customer['fullName'] = $oCustomer->firstname.' '.$oCustomer->lastname;
        $customer['emailAddress'] = $oCustomer->email;

        $oOmnikassa->setCustomerInformation($customer);

        $oOmnikassa->setAccessToken();

        if ($oOmnikassa->getTransaction()) {
            if ($sRedirectUrl = $oOmnikassa->getTransactionUrl()) {
                $sTransactionId = $oOmnikassa->getOmnikassaOrderId();

                $iPendingStatus = Configuration::get('ICROK2_OS_PENDING');
                $aParams = ['transaction_id' => $sTransactionId];

                // Create order
                $this->module->validateOrder(
                    (int) $oCart->id,
                    $iPendingStatus,
                    $fAmount,
                    $sPaymentCode,
                    null,
                    $aParams,
                    (int) $oCurrency->id,
                    false,
                    $oCustomer->secure_key
                );

                Tools::redirect($sRedirectUrl);
            } else {
                // No URL received, so there must be something wrong
                $sError = $oOmnikassa->getError();
                $this->errors[] = $sError;

                $this->redirectWithNotifications(__PS_BASE_URI__.'order.php?step=4');
                exit;
            }
        } else {
            // No Transaction received, so there must be something wrong
            $sError = $oOmnikassa->getError();
            $this->errors[] = $sError;

            $this->redirectWithNotifications(__PS_BASE_URI__.'order.php?step=4');
            exit;
        }
    }
}
