<?php
/**
 * CodeBrain BV       https://www.codebrain.nl.
 *
 * @author      CodeBrain B.V. <info@codebrain.nl>
 * @copyright   Codebrain B.V.
 * @license     https://opensource.org/licenses/bsd-license.php
 *
 * @see        https://www.ideal-checkout.nl/
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class IcOmnikassaReturnModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $display_column_left = false;

    public function initContent()
    {
        parent::initContent();

        $sMerchantOrderId = Tools::getValue('order_id');
        $sOmniKassaStatus = Tools::getValue('status');
        $sSignature = Tools::getValue('signature');

        if (empty($sMerchantOrderId) || empty($sOmniKassaStatus) || empty($sSignature)) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        // Init Rabo Smart Pay
        $bSandbox = (bool) Configuration::get('ICROK2_SANDBOX');

        $sRefreshToken = '';
        $sSigningKey = '';

        if ($bSandbox) {
            $sRefreshToken = Configuration::get('ICROK2_REFRESHTOKEN_SANDBOX');
            $sSigningKey = Configuration::get('ICROK2_SIGNINGKEY_SANDBOX');
        } else {
            $sRefreshToken = Configuration::get('ICROK2_REFRESHTOKEN_PRODUCTION');
            $sSigningKey = Configuration::get('ICROK2_SIGNINGKEY_PRODUCTION');
        }

        $oOmnikassa = new OmnikassaPayment($sRefreshToken, $sSigningKey);

        $sHashString = $sMerchantOrderId.','.$sOmniKassaStatus;

        if ($oOmnikassa->isValidRequest($sHashString, $sSignature)) {
            if ($sOmniKassaStatus == 'COMPLETED' || $sOmniKassaStatus == 'PENDING') {
                $sOrderId = Order::getIdByCartId($sMerchantOrderId);
                $oOrder = new Order($sOrderId);
                $oCustomer = new Customer($oOrder->id_customer);

                $sRedirectUrl = 'index.php?controller=order-confirmation';
                $sRedirectUrl .= '&id_cart='.$sMerchantOrderId;
                $sRedirectUrl .= '&id_module='.$this->module->id;
                $sRedirectUrl .= '&id_order='.$sOrderId;
                $sRedirectUrl .= '&key='.$oCustomer->secure_key;
                $sRedirectUrl .= '&success=true';

                Tools::redirect($sRedirectUrl);
            } else {
                $sRedirectUrl = $this->context->link->getPageLink('order.php');
                Tools::redirect($sRedirectUrl);
            }
        } else {
            $sRedirectUrl = $this->context->link->getPageLink('order.php');
            Tools::redirect($sRedirectUrl);
        }
    }
}
