<?php
/**
 * CodeBrain BV       https://www.codebrain.nl.
 *
 * @author      CodeBrain B.V. <info@codebrain.nl>
 * @copyright   Codebrain B.V.
 * @license     https://opensource.org/licenses/bsd-license.php
 *
 * @see        https://www.ideal-checkout.nl/
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class IcOmnikassaWebhookModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $display_column_left = false;

    public function initContent()
    {
        parent::initContent();

        $sJsonData = Tools::file_get_contents('php://input');

        if (empty($sJsonData)) {
            http_response_code(400);
            exit('Invalid notification call, no data found');
        } else {
            $aPostData = json_decode($sJsonData, true);

            if (isset($aPostData['authentication'])
            && isset($aPostData['expiry'])
            && isset($aPostData['eventName'])
            && isset($aPostData['poiId'])
            && isset($aPostData['signature'])) {
                $sAuthToken = $aPostData['authentication'];
                $sExpiryString = $aPostData['expiry'];
                $sEventnameString = $aPostData['eventName'];
                $sPoiIdString = $aPostData['poiId'];
                $sSignatureString = $aPostData['signature'];

                // Check the signature that was sent with the data
                $sHashString = $sAuthToken.','.$sExpiryString.','.$sEventnameString.','.$sPoiIdString;

                // Init Rabo Smart Pay
                $bSandbox = (bool) Configuration::get('ICROK2_SANDBOX');

                $sRefreshToken = '';
                $sSigningKey = '';

                if ($bSandbox) {
                    $sRefreshToken = Configuration::get('ICROK2_REFRESHTOKEN_SANDBOX');
                    $sSigningKey = Configuration::get('ICROK2_SIGNINGKEY_SANDBOX');
                } else {
                    $sRefreshToken = Configuration::get('ICROK2_REFRESHTOKEN_PRODUCTION');
                    $sSigningKey = Configuration::get('ICROK2_SIGNINGKEY_PRODUCTION');
                }

                $oOmnikassa = new OmnikassaPayment($sRefreshToken, $sSigningKey);
                $oOmnikassa->setTestmode($bSandbox);

                if ($oOmnikassa->isValidRequest($sHashString, $sSignatureString)) {
                    $aResult = [];

                    do {
                        $sResponse = $oOmnikassa->getNotificationData($sAuthToken);
                        $aResult = json_decode($sResponse, true);

                        if (isset($aResult['signature'])
                        && isset($aResult['moreOrderResultsAvailable'])
                        && isset($aResult['orderResults'])) {
                            $sSignature = $aResult['signature'];
                            $bMoreOrders = $aResult['moreOrderResultsAvailable'];

                            if ($bMoreOrders) {
                                $sMoreOrdersAvailable = 'true';
                            } else {
                                $sMoreOrdersAvailable = 'false';
                            }

                            $sHashString = $sMoreOrdersAvailable.',';

                            // Validate total signature
                            foreach ($aResult['orderResults'] as $aRokResult) {
                                // Setup total hash string
                                $sTransactionString = $aRokResult['merchantOrderId'].',';
                                $sTransactionString .= $aRokResult['omnikassaOrderId'].',';
                                $sTransactionString .= $aRokResult['poiId'].',';
                                $sTransactionString .= $aRokResult['orderStatus'].',';
                                $sTransactionString .= $aRokResult['orderStatusDateTime'].',';
                                $sTransactionString .= $aRokResult['errorCode'].',';
                                $sTransactionString .= $aRokResult['paidAmount']['currency'].',';
                                $sTransactionString .= $aRokResult['paidAmount']['amount'].',';
                                $sTransactionString .= $aRokResult['totalAmount']['currency'].',';
                                $sTransactionString .= $aRokResult['totalAmount']['amount'];

                                // Add all transactions
                                foreach ($aRokResult['transactions'] as $aTransaction) {
                                    if (isset($aTransaction['confirmedAmount']) && isset($aTransaction['confirmedAmount']['currency']) && isset($aTransaction['confirmedAmount']['amount'])) {
                                        $sTransactionString .= ','.$aTransaction['id'].',';
                                        $sTransactionString .= $aTransaction['paymentBrand'].',';
                                        $sTransactionString .= $aTransaction['type'].',';
                                        $sTransactionString .= $aTransaction['status'].',';
                                        $sTransactionString .= $aTransaction['amount']['currency'].',';
                                        $sTransactionString .= $aTransaction['amount']['amount'].',';
                                        $sTransactionString .= $aTransaction['confirmedAmount']['currency'].',';
                                        $sTransactionString .= $aTransaction['confirmedAmount']['amount'].',';
                                        $sTransactionString .= $aTransaction['startTime'].',';
                                        $sTransactionString .= $aTransaction['lastUpdateTime'];
                                    } else {
                                        $sTransactionString .= ','.$aTransaction['id'].',';
                                        $sTransactionString .= $aTransaction['paymentBrand'].',';
                                        $sTransactionString .= $aTransaction['type'].',';
                                        $sTransactionString .= $aTransaction['status'].',';
                                        $sTransactionString .= $aTransaction['amount']['currency'].',';
                                        $sTransactionString .= $aTransaction['amount']['amount'].',';
                                        $sTransactionString .= ',';
                                        $sTransactionString .= ',';
                                        $sTransactionString .= $aTransaction['startTime'].',';
                                        $sTransactionString .= $aTransaction['lastUpdateTime'];
                                    }
                                }

                                $sHashString .= $sTransactionString.',';
                            }

                            // Cut off last comma
                            $sHashString = Tools::substr($sHashString, 0, -1);

                            if ($oOmnikassa->isValidRequest($sHashString, $sSignature)) {
                                foreach ($aResult['orderResults'] as $aTransaction) {
                                    $sMerchantOrderId = $aTransaction['merchantOrderId'];
                                    $sOmniKassaStatus = $aTransaction['orderStatus'];
                                    // $sTransactionId = $aTransaction['omnikassaOrderId'];

                                    $aTransactionData = $oOmnikassa->getTransactionFromWebhook($aTransaction['transactions']);

                                    $sTransactionId = $aTransactionData['id'];
                                    $sTransactionMethod = $aTransactionData['paymentBrand'];

                                    // Get order by Merchant Order ID
                                    $sOrderId = Order::getIdByCartId($sMerchantOrderId);
                                    $oOrder = new Order($sOrderId);

                                    $iOrderState = (int) $oOrder->getCurrentState();

                                    $iConfigurationOrderState = (int) Configuration::get('ICROK2_OS_PENDING');

                                    // Our pending state, dont change if otherwise?
                                    if (strcmp($iOrderState, $iConfigurationOrderState) === 0) {
                                        if (strcmp($sOmniKassaStatus, 'COMPLETED') === 0) {
                                            $oOrderHistory = new OrderHistory();

                                            $iPaidState = (int) Configuration::get('PS_OS_PAYMENT');

                                            $oOrderHistory->id_order = (int) $sOrderId;
                                            $oOrderHistory->changeIdOrderState($iPaidState, $sOrderId, true);
                                            $oOrderHistory->addWithemail();
                                        } elseif (in_array($sOmniKassaStatus, ['CANCELLED', 'EXPIRED'])) {
                                            $oOrderHistory = new OrderHistory();

                                            $iCancelledState = (int) Configuration::get('PS_OS_CANCELED');

                                            $oOrderHistory->id_order = (int) $sOrderId;
                                            $oOrderHistory->changeIdOrderState($iCancelledState, $sOrderId, true);
                                        }
                                    }
                                }
                            }
                        } else {
                            error_log('Invalid return from the Order Results call: '.json_encode($aResult));
                            http_response_code(400);
                            exit('Invalid notification call, incorrect Smart Pay data');
                        }
                    } while ($bMoreOrders);
                }
            } else {
                http_response_code(400);
                exit('Invalid notification call, data imcomplete');
            }
        }

        http_response_code(200);
        exit('Webhook processed');
    }
}
