<?php
/**
 * CodeBrain BV       https://www.codebrain.nl.
 *
 * @author      CodeBrain B.V. <info@codebrain.nl>
 * @copyright   Codebrain B.V.
 * @license     https://opensource.org/licenses/bsd-license.php
 *
 * @see        https://www.ideal-checkout.nl/
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

function idealcheckout_doHttpRequest(
    $sUrl,
    $sPostData = false,
    $bRemoveHeaders = false,
    $iTimeout = 30,
    $bDebug = false,
    $aAdditionalHeaders = false
) {
    global $bIdealcheckoutCurlVerificationError;

    if (!isset($bIdealcheckoutCurlVerificationError)) {
        $bIdealcheckoutCurlVerificationError = false;
    }

    $aUrl = parse_url($sUrl);

    $bHttps = false;
    $sRequestUrl = '';

    if (in_array($aUrl['scheme'], ['ssl', 'https'])) {
        $sRequestUrl .= 'https://';
        $bHttps = true;

        if (empty($aUrl['port'])) {
            $aUrl['port'] = 443;
        }
    } else {
        $sRequestUrl .= 'http://';

        if (empty($aUrl['port'])) {
            $aUrl['port'] = 80;
        }
    }

    $sRequestUrl .= $aUrl['host'];
    $sRequestUrl .= (empty($aUrl['path']) ? '/' : $aUrl['path']);
    $sRequestUrl .= (empty($aUrl['query']) ? '' : '?'.$aUrl['query']);

    if (is_array($sPostData)) {
        $sPostData = str_replace(['%5B', '%5D'], ['[', ']'], http_build_query($sPostData));
    }

    if ($bDebug === true) {
        $sRequest = 'Requested URL: '.$sRequestUrl."\r\n";
        $sRequest .= 'Portnumber: '.$aUrl['port']."\r\n";

        if ($sPostData) {
            $sRequest .= 'Posted data: '.$sPostData."\r\n";
        }

        echo "\r\n\r\n".'<h1>SEND DATA:</h1>'."\r\n".'<code style="display: block; background: #E0E0E0; border: #000000 solid 1px; padding: 10px;">'.str_replace(["\n", "\r"], ['<br>'."\r\n", ''], htmlspecialchars($sRequest)).'</code>'."\r\n\r\n";
    }

    $oCurl = curl_init();
    $oCertInfo = false;

    if ($bHttps && $bDebug) {
        $oCertInfo = tmpfile();

        $sHostName = ($bHttps ? 'https://' : 'http://');
        $sHostName .= $aUrl['host'];
        $sHostName .= (empty($aUrl['port']) ? '' : ':'.$aUrl['port']);
    }

    curl_setopt($oCurl, CURLOPT_URL, $sRequestUrl);
    curl_setopt($oCurl, CURLOPT_PORT, $aUrl['port']);

    if ($bHttps && ($bIdealcheckoutCurlVerificationError == false)) {
        curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, 2);

        if ($oCertInfo) {
            curl_setopt($oCurl, CURLOPT_STDERR, $oCertInfo);
            curl_setopt($oCurl, CURLOPT_VERBOSE, true);
            curl_setopt($oCurl, CURLOPT_CERTINFO, true);
        }
    }

    curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);

    // Adjustment htaccess 301 redirect
    curl_setopt($oCurl, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($oCurl, CURLOPT_MAXREDIRS, 1);

    curl_setopt($oCurl, CURLOPT_TIMEOUT, $iTimeout);
    curl_setopt($oCurl, CURLOPT_HEADER, $bRemoveHeaders == false);

    if (substr($sPostData, 0, 1) == '{') {
        if (!is_array($aAdditionalHeaders)) {
            $aAdditionalHeaders = [];
        }

        $aAdditionalHeaders[] = 'Content-Type: application/json';
    }

    if (is_array($aAdditionalHeaders) && sizeof($aAdditionalHeaders)) {
        curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aAdditionalHeaders);
    }

    if ($sPostData != false) {
        curl_setopt($oCurl, CURLOPT_POST, true);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sPostData);
    }

    $sResponse = curl_exec($oCurl);

    // Capture certificate info
    if ($bHttps && $oCertInfo) {
        fseek($oCertInfo, 0);

        $sCertInfo = '';

        while ($s = fread($oCertInfo, 8192)) {
            $sCertInfo .= $s;
        }

        fclose($oCertInfo);
    }

    curl_close($oCurl);

    if ($bDebug === true) {
        echo "\r\n\r\n".'<h1>RECIEVED DATA:</h1>'."\r\n".'<code style="display: block; background: #E0E0E0; border: #000000 solid 1px; padding: 10px;">'.str_replace(["\n", "\r"], ['<br>'."\r\n", ''], htmlspecialchars($sResponse)).'</code>'."\r\n\r\n";
    }

    if (empty($sResponse)) {
        return '';
    }

    return $sResponse;
}

function idealcheckout_log($sText, $sFile = false, $iLine = false, $bDebugCheck = true)
{
    if (!$bDebugCheck) {
        $this->log->write($sText);

        return true;
    }

    return false;
}

function icomnikassa_mb_splitAddress($sAddress)
{
    // Get everything up to the first number with a regex
    $bHasMatch = preg_match('/^[^0-9]*/', $sAddress, $aMatch);

    // If no matching is possible, return the supplied string as the street
    if (!$bHasMatch) {
        return [$sAddress, '', ''];
    }

    // Remove the street from the sAddress.
    $sAddress = str_replace($aMatch[0], '', $sAddress);
    $sStreetname = trim($aMatch[0]);

    // Nothing left to split, return the streetname alone
    if (strlen($sAddress == 0)) {
        return [$sStreetname, '', ''];
    }

    // Explode sAddress to an array using a multiple explode function
    $aAddress = icomnikassa_mb_multiExplodeArray([' ', '-', '|', '&', '/', '_', '\\'], $sAddress);

    // Shift the first element off the array, that is the house number
    $iHousenumber = array_shift($aAddress);

    // If the array is empty now, there is no extension.
    if (count($aAddress) == 0) {
        return [$sStreetname, $iHousenumber, ''];
    }

    // Join together the remaining pieces as the extension.
    $sExtension = substr(implode(' ', $aAddress), 0, 4);

    return [$sStreetname, $iHousenumber, $sExtension];
}

function icomnikassa_mb_multiExplodeArray($aDelimiter, $sString)
{
    $sInput = str_replace($aDelimiter, $aDelimiter[0], $sString);
    $aArray = explode($aDelimiter[0], $sInput);

    return $aArray;
}
