<?php

	if(!defined('LF'))
	{
		define('LF', chr(10)); // Line feed '\n'
	}

	if(!defined('TAB'))
	{
		define('TAB', chr(9)); // Tab '\t'
	}

	if(!defined('DS')) // Directory seperator
	{
		define('DS', DIRECTORY_SEPARATOR);
		// define('DS', (strpos(dirname(__FILE__), '\\') ? '\\' : '/'));
	}

	if(!defined('IDEALCHECKOUT_PATH'))
	{
		define('IDEALCHECKOUT_PATH', dirname(dirname(__DIR__)));
	}

	if(!defined('SOFTWARE_PATH'))
	{
		define('SOFTWARE_PATH', dirname(dirname(dirname(__DIR__))));
	}





	// Initiate software
	$sSoftwareClass = IDEALCHECKOUT_INSTALL::setSoftware();

	if(empty($sSoftwareClass))
	{
		idealcheckout_output('<p>Cannot detect the current software!<br>Please try to install another plug-in or version suitable for your software.</p>');
	}

	$_REQUEST = array();
	$_REQUEST['software'] = $sSoftwareClass;
	$_REQUEST['settings'] = false;

	$sInstallFile = dirname(dirname(dirname(__FILE__))) . '/configuration/install.php';

	if(is_file($sInstallFile))
	{
		$_REQUEST['settings'] = include($sInstallFile);
	}





	// Verify read/write privileges
	$_REQUEST['files-and-folders'] = IDEALCHECKOUT_INSTALL::getFilesAndFolders($sSoftwareClass);

	$bWritable = true;

	foreach($_REQUEST['files-and-folders'] as $sPath)
	{
		if(!is_writable($sPath))
		{
			$bWritable = false;
			break;
		}
	}

	if(!defined('FTP_ACCESS_REQUIRED'))
	{
		define('FTP_ACCESS_REQUIRED', $bWritable === false);
	}

/*
	$a = get_defined_constants(true);
	print_r($a['user']);
*/




	$_REQUEST['psp'] = array();
	
	
	$_REQUEST['psp']['idealcheckout']['name'] = 'iDEAL Simulator / iDEAL Checkout';
	$_REQUEST['psp']['idealcheckout']['gateways'] = array();
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Creditcard', 'type' => 'creditcard', 'name' => 'Creditcard', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Authorized Transfer', 'type' => 'authorizedtransfer', 'name' => 'Eenmalige machtiging', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Manual Transfer', 'type' => 'manualtransfer', 'name' => 'Handmatige overboeking', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - iDEAL', 'type' => 'ideal', 'name' => 'iDEAL', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Klarnaaccount', 'type' => 'klarnaaccount', 'name' => 'Klarnaaccount', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Klarnabuynow', 'type' => 'klarnabuynow', 'name' => 'Klarna Buy Now', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Klarnainvoice', 'type' => 'klarnainvoice', 'name' => 'Klarnainvoice', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Maestro', 'type' => 'maestro', 'name' => 'Maestro', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Mastercard', 'type' => 'mastercard', 'name' => 'Mastercard', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Bancontact', 'type' => 'bancontact', 'name' => 'Bancontact', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - PayPal', 'type' => 'paypal', 'name' => 'PayPal', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - PaySafeCard', 'type' => 'paysafecard', 'name' => 'PaySafeCard', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Sofortbanking', 'type' => 'sofortbanking', 'name' => 'Sofortbanking', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - Visa', 'type' => 'visa', 'name' => 'Visa', 'dashboard' => '');
	$_REQUEST['psp']['idealcheckout']['gateways'][] = array('code' => 'iDEAL Simulator - VPAY', 'type' => 'vpay', 'name' => 'VPAY', 'dashboard' => '');


	$_REQUEST['psp']['rabobank']['name'] = 'Rabobank';
	$_REQUEST['psp']['rabobank']['gateways'] = array();

	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - ALL', 'type' => 'ideal', 'name' => 'Rabo OmniKassa 2.0 - ALL', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - iDEAL', 'type' => 'ideal', 'name' => 'Rabo OmniKassa 2.0 - iDEAL', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - Creditcard', 'type' => 'creditcard', 'name' => 'Rabo OmniKassa 2.0 - Creditcard', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - Afterpay', 'type' => 'afterpay', 'name' => 'Rabo OmniKassa 2.0 - Afterpay', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - Maestro', 'type' => 'maestro', 'name' => 'Rabo OmniKassa 2.0 - Maestro', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - Mastercard', 'type' => 'mastercard', 'name' => 'Rabo OmniKassa 2.0 - Mastercard', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - Bancontact', 'type' => 'bancontact', 'name' => 'Rabo OmniKassa 2.0 - Bancontact', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - PayPal', 'type' => 'paypal', 'name' => 'Rabo OmniKassa 2.0 - PayPal', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - Visa', 'type' => 'visa', 'name' => 'Rabo OmniKassa 2.0 - Visa', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabo OmniKassa 2.0 - vPay', 'type' => 'vpay', 'name' => 'Rabo OmniKassa 2.0 - vPay', 'dashboard' => 'Om de Rabo OmniKassa te koppelen aan uw website heeft u toegang gekregen tot een beheeromgeving van de <a href="https://bankieren.rabobank.nl/omnikassa-dashboard/" title="https://bankieren.rabobank.nl/omnikassa-dashboard/">Rabo OmniKassa 2.0</a>.<br><br>Rechts bovenin ziet u het tabje "Beheer", in de tweede menu laag het kopje: "Winkels en verkooppunten". Hier vind u de configuratie sleutels die u nodig heeft voor de configuratie van uw betaalmethode\'s.<br><br>Vul de gevonden gegevens hieronder in bij uw plugin instellingen.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');


	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabobank - iDEAL Internet Kassa', 'type' => 'ideal', 'name' => 'iDEAL Internet Kassa', 'dashboard' => 'Van uw bank/PSP heeft u toegang tot een speciaal dashboard gekregen waar u alle informatie vind om uw webshop aan de Internet Kassa te koppelen. De URL van dit dashboard is: <a href="https://i-kassa.rabobank.nl/rik/prod/backoffice" target="_blank">https://i-kassa.rabobank.nl/rik/prod/backoffice</a>.<br><br>Bij de eerste keer inloggen op dit dashboard moet u mogelijk diverse zaken configureren zoals uw contact gegevens. Heeft u vragen over dit dashboard, dan kunt u contact op nemen met de "Special Desk e-Commerce" van de Rabobank: 020 - 383 24 94 (lokaal tarief).<br><br>Om onze plug-in goed te laten samenwerken met uw Internet Kassa account, moet u op uw dashboard een aantal beveiligingsinstellingen goed configureren. Log daarom in op uw <a href="https://i-kassa.rabobank.nl/rik/prod/backoffice" target="_blank">Internet Kassa Dashboard</a> en klik in het hoofdmenu op "Configureren" en daarna op "Technische Informatie".<br><br>Controleer per tabblad de volgende instellingen:<br><br>TAB: Algemene transactieparameters<br>- "Standaard operatiecode" = "Verkoop"<br>- "Verwerking van individuele transacties" = "Online maar overschakelen naar offline wanneer het online systeem van de acquirer niet beschikbaar is."<br><br>TAB: Algemene beveiligingsparameters<br>- "Stel de hash-reeks samen door de waarde samen te voegen van:" = "Elke parameter gevolgd door de passphrase."<br>- "Hash-algoritme:" = "SHA-1"<br>- "Karaktercodering:" = "ISO-8859-1"<br><br>TAB: Verificatie data en herkomst<br>- "URL van pagina van de merchant die.." = http://www.url-van-uw-webshop.nl/idealcheckout/setup.php<br>- "SHA-1-IN versleuteling" = Vul een unieke code in, bestaande uit letters en cijfers. Hoe langer hoe veiliger!<br><br>Tip: Als uw domeinnaam met en zonder "www." gebruikt kan worden, en met zowel http:// als https://, adviseren we voor elke combinatie van uw domeinnaam op te nemen in het veld "URL van pagina van de merchant die..".<br><br>TAB: Transactiefeedback<br>- "Ik wil de feedbackparameters van de transacties op de redirectie-URL\'s ontvangen." = Aanvinken<br>- "Ik wil dat Online kassa een kort redirectiebericht toont aan de klant voordat deze wordt teruggestuurd naar mijn website." = Uitvinken<br>- "SHA-1-OUT Versleuteling" = Vul een unieke code in, bestaande uit letters en cijfers, 12 tot 16 karakters<br>- "Dynamische e-commerce-parameters" = Selecteer de waarden "ORDERID", "PAYID", "PM" en "STATUS".<br><br>Neem uw PSP ID, SHA-1-IN en SHA-1-OUT key uit uw Internet Kassa Dashboard over in de onderstaande velden. Na het opslaan van de configuratie is uw webshop klaar om betalingen te ontvangen. Om uw configuratie snel te controleren kunt u gebruik maken van het <a href="../test.php" target="_blank">test script</a>.');
	$_REQUEST['psp']['rabobank']['gateways'][] = array('code' => 'Rabobank - iDEAL Professional', 'type' => 'ideal', 'name' => 'iDEAL Professional', 'dashboard' => '<b>SSL Certificaten verkrijgen</b><br>Voor het koppelen van uw iDEAL account aan uw webshop heeft u o.a. een speciaal &quot;SSL certificaat&quot; nodig. Dit certificaat is onderdeel van de beveiliging van de communicatie met het iDEAL systeem.<br><br>Via onze online <a href="https://www.ideal-checkout.nl/ssl/ssl-automatisch-genereren" target="_blank">certificaten generator</a> kunt u deze eenvoudig zelf genereren. Na het invullen van de gewenste certificaat gegevens ontvangt u via de website een ZIP bestand met hierin 3 belangrijke bestanden ([bedrijfsnaam].cer, [bedrijfsnaam].key en [bedrijfsnaam].php). Unzip deze bestanden en upload ze via uw FTP programma in de map "[uw webshop]/idealcheckout/certificates/". U kunt deze bestanden desgewenst naar eigen inzicht hernoemen.<br><br>Houdt deze bestanden bij de hand, u heeft ze bij het configureren van de plug-in nodig!<br>- De .cer en .key bestanden heeft de plug-in nodig om uw berichten te beveiligen.<br>- Het .cer bestand heeft de bank nodig om uw berichten te controleren.<br>- Het .php bestand bevat het wachtwoord dat gebruikt is bij het genereren van het certificaat.<br><br><br><b>Nieuwe iDEAL accounts</b><br>Heeft u een nieuw iDEAL account, dan moet u eerst een verplichte test procedure doorlopen voor u uw account kunt activeren. Bij deze test procedure moeten 6 test betalingen (van exact &euro; 1, &euro; 2, &euro; 3, &euro; 4, &euro; 5 en &euro; 7) worden doorlopen.<br><br>Om deze test procedure te kunnen doorlopen heeft u van de Rabobank toegang gekregen tot een <a href="https://idealtest.rabobank.nl" target="_blank" title="https://idealtest.rabobank.nl">TEST dashboard</a>). Op dit dashboard vindt u o.a. uw <b>Merchant ID</b> en <b>Sub ID</b> (eigenlijk altijd "0"). Op dit dashboard moet u tevens uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security".<br><br>Vul vervolgens hieronder bij de plug-in instellingen uw gegevens en de namen van uw .cer bestand en uw .key bestand goed in (inclusief extensie). Sla daarna de configuratie op.<br><br>U kunt nu gebruik maken van het <a href="../test.php" target="_blank">test script</a> om de 6 verplichte testbetalingen te doorlopen. Zorg er voor dat u hierbij steeds "iDEAL" als betaalmethode kiest en het juiste test bedrag invult.<br><br>Na het doorlopen van de 6 test betalingen ziet u in uw test dashboard onder tabje "Status" dat uw test betalingen succesvol zijn doorlopen (dit kan soms een paar minuten duren i.v.m. Cache). Zolang deze vinkjes niet op groen komen te staan, kan uw account niet worden klaargezet voor activatie!<br><br>Nadat u de test procedure volledig heeft doorlopen, ontvangt u binnen 1 werkdag per e-mail een bevestiging dat u uw live account kunt activeren. U kunt daarna inloggen op uw <a href="https://ideal.rabobank.nl" target="_blank" title="https://ideal.rabobank.nl">LIVE Dashboard</a> om daar uw account te activeren (tabje: activeren).<br><br>Voor meer informatie over deze test procedure, en de 6 verplichte test betalingen kunt u contact opnemen met de Rabobank of met onze helpdesk.<br><br><br><b>Ontvangen van echte betalingen</b> (voor geactiveerde accounts)<br>Op het <a href="https://ideal.rabobank.nl" target="_blank" title="https://ideal.rabobank.nl">LIVE dashboard</a> moet u uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security". Pas de configuratie van uw plug-in aan zodat deze nu verwijst naar de LIVE omgeving.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');


	$_REQUEST['psp']['cashflows']['name'] = 'Cashflows';
	$_REQUEST['psp']['cashflows']['gateways'] = array();
	$_REQUEST['psp']['cashflows']['gateways'][] = array('code' => 'Cashflows - Creditcard', 'type' => 'creditcard', 'name' => 'Creditcard', 'dashboard' => 'Om een koppeling met Cashflows te configureren heeft u een <b>API Key</b> en een <b>Configuration ID</b> nodig.<br><br>Deze vindt u in uw Cashflows dashboard op <a href="https://www.cashflows.com" target="_blank">https://www.cashflows.com</a>');
	// $_REQUEST['psp']['cashflows']['gateways'][] = array('code' => 'Cashflows - PayPal', 'type' => 'paypal', 'name' => 'PayPal', 'dashboard' => 'Om een koppeling met Cashflows te configureren heeft u een <b>Primary Password</b> en een <b>Configuration ID</b> nodig.<br><br>Deze vindt u in uw Cashflows dashboard op <a href="https://www.cashflows.com" target="_blank">https://www.cashflows.com</a>');


	$_REQUEST['psp']['sisow']['name'] = 'Sisow';
	$_REQUEST['psp']['sisow']['gateways'] = array();
	$_REQUEST['psp']['sisow']['gateways'][] = array('code' => 'Sisow - Sofortbanking', 'type' => 'sofortbanking', 'name' => 'Sofortbanking', 'dashboard' => 'Om een koppeling met Sisow te configureren heeft u een <b>Merchant ID</b> en een <b>Merchant Key</b> nodig.<br>Aanvullend kunt u een Shop ID als u 1 Sisow account voor meerdere webshops gebruikt.<br><br>Al deze gegevens vindt u in uw Sisow dashboard op <a href="https://www.sisow.nl" target="_blank">https://www.sisow.nl</a>');
	$_REQUEST['psp']['sisow']['gateways'][] = array('code' => 'Sisow - iDEAL', 'type' => 'ideal', 'name' => 'iDEAL', 'dashboard' => 'Om een koppeling met Sisow te configureren heeft u een <b>Merchant ID</b> en een <b>Merchant Key</b> nodig.<br>Aanvullend kunt u een Shop ID als u 1 Sisow account voor meerdere webshops gebruikt.<br><br>Al deze gegevens vindt u in uw Sisow dashboard op <a href="https://www.sisow.nl" target="_blank">https://www.sisow.nl</a>');
	$_REQUEST['psp']['sisow']['gateways'][] = array('code' => 'Sisow - Bancontact', 'type' => 'bancontact', 'name' => 'Bancontact / Bancontact', 'dashboard' => 'Om een koppeling met Sisow te configureren heeft u een <b>Merchant ID</b> en een <b>Merchant Key</b> nodig.<br>Aanvullend kunt u een Shop ID als u 1 Sisow account voor meerdere webshops gebruikt.<br><br>Al deze gegevens vindt u in uw Sisow dashboard op <a href="https://www.sisow.nl" target="_blank">https://www.sisow.nl</a>');
	$_REQUEST['psp']['sisow']['gateways'][] = array('code' => 'Sisow - PayPal', 'type' => 'paypal', 'name' => 'PayPal', 'dashboard' => 'Om een koppeling met Sisow te configureren heeft u een <b>Merchant ID</b> en een <b>Merchant Key</b> nodig.<br>Aanvullend kunt u een Shop ID als u 1 Sisow account voor meerdere webshops gebruikt.<br><br>Al deze gegevens vindt u in uw Sisow dashboard op <a href="https://www.sisow.nl" target="_blank">https://www.sisow.nl</a>');

	$_REQUEST['psp']['onlinebetaalplatform']['name'] = 'Online Betaalplatform';
	$_REQUEST['psp']['onlinebetaalplatform']['gateways'] = array();
	$_REQUEST['psp']['onlinebetaalplatform']['gateways'][] = array('code' => 'Online Betaalplatform - iDEAL', 'type' => 'ideal', 'name' => 'iDEAL', 'dashboard' => 'Om een koppeling met Online Betaalplatform te configureren heeft u een <b>API key</b> en <b>Profile UID</b> nodig.<br>Deze vindt u in uw Online Betaalplatform Dashboard op: <br><a href="https://onlinebetaalplatform.nl/nl/login" target="_blank">https://onlinebetaalplatform.nl/nl/login</a>');
	$_REQUEST['psp']['onlinebetaalplatform']['gateways'][] = array('code' => 'Online Betaalplatform - Handmatig Overboeken', 'type' => 'manualtransfer', 'name' => 'Handmatig Overboeken', 'dashboard' => 'Om een koppeling met Online Betaalplatform te configureren heeft u een <b>API key</b> en <b>Profile UID</b> nodig.<br>Deze vindt u in uw Online Betaalplatform Dashboard op: <br><a href="https://onlinebetaalplatform.nl/nl/login" target="_blank">https://onlinebetaalplatform.nl/nl/login</a>');
	$_REQUEST['psp']['onlinebetaalplatform']['gateways'][] = array('code' => 'Online Betaalplatform - Bancontact', 'type' => 'bancontact', 'name' => 'Bancontact', 'dashboard' => 'Om een koppeling met Online Betaalplatform te configureren heeft u een <b>API key</b> en <b>Profile UID</b> nodig.<br>Deze vindt u in uw Online Betaalplatform Dashboard op: <br><a href="https://onlinebetaalplatform.nl/nl/login" target="_blank">https://onlinebetaalplatform.nl/nl/login</a>');
	$_REQUEST['psp']['onlinebetaalplatform']['gateways'][] = array('code' => 'Online Betaalplatform - Creditcard', 'type' => 'creditcard', 'name' => 'Creditcard', 'dashboard' => 'Om een koppeling met Online Betaalplatform te configureren heeft u een <b>API key</b> en <b>Profile UID</b> nodig.<br>Deze vindt u in uw Online Betaalplatform Dashboard op: <br><a href="https://onlinebetaalplatform.nl/nl/login" target="_blank">https://onlinebetaalplatform.nl/nl/login</a>');
	$_REQUEST['psp']['onlinebetaalplatform']['gateways'][] = array('code' => 'Online Betaalplatform - PayPal', 'type' => 'paypal', 'name' => 'Paypal', 'dashboard' => 'Om een koppeling met Online Betaalplatform te configureren heeft u een <b>API key</b> en <b>Profile UID</b> nodig.<br>Deze vindt u in uw Online Betaalplatform Dashboard op: <br><a href="https://onlinebetaalplatform.nl/nl/login" target="_blank">https://onlinebetaalplatform.nl/nl/login</a>');
	

	$_REQUEST['psp']['abnamro']['name'] = 'ABN Amro';
	$_REQUEST['psp']['abnamro']['gateways'] = array();
	$_REQUEST['psp']['abnamro']['gateways'][] = array('code' => 'ABN Amro - iDEAL Easy', 'type' => 'ideal', 'name' => 'iDEAL Easy', 'dashboard' => 'Van uw bank/PSP heeft u een e-mail of brief ontvangen, waarop u uw PSP ID kunt terug vinden. U kunt deze ook opvragen bij de "Special Desk e-Commerce" van de ABN Amro: 020 - 383 24 94 (lokaal tarief).<br><br>iDEAL Easy is beveiligd zodat alleen betalingen vanaf specifieke URLs gestart mogen worden. U moet aan de "Special Desk e-Commerce" doorgeven vanaf welke URLs de betalingen gestart kunnen worden. Houdt hierbij rekening of uw URLs beginnen met http:// of https:// en of uw URLs wel of niet "www" bevatten.<br><br><span class="lightbulb"><i>Let op: Deze iDEAL variant biedt geen terugkoppeling van de betaalstatus, en is daarom voor veel webshoppakketten ongeschikt! U kunt in veel gevallen beter gebruik maken van iDEAL Zelfbouw.</i></span>');
	$_REQUEST['psp']['abnamro']['gateways'][] = array('code' => 'ABN Amro - iDEAL Easy (Beveiligd)', 'type' => 'ideal', 'name' => 'iDEAL Easy (Beveiligd)', 'dashboard' => 'Van uw bank/PSP heeft u een e-mail of brief ontvangen, waarop u uw PSP ID kunt terug vinden. U kunt deze ook opvragen bij de "Special Desk e-Commerce" van de ABN Amro: 020 - 383 24 94 (lokaal tarief).<br><br>Voor het beveiligd versturen van bestelgegevens naar de ABN Amro omgeving kunt u een "SHA-1-IN"-key laten instellen door de "Special Desk e-Commerce".<br><br>iDEAL Easy is beveiligd zodat alleen betalingen vanaf specifieke domeinnamen gestart mogen worden. U moet aan de "Special Desk e-Commerce" doorgeven vanaf welke domeinnaam de betalingen gestart zullen worden. Houdt hierbij rekening of uw domeinnaam beginnen met http:// of https:// en of uw domeinnaam wel of niet "www" bevat.<br><br><span class="lightbulb"><i>Let op: Deze iDEAL variant biedt geen terugkoppeling van de betaalstatus, en is daarom voor veel webshoppakketten ongeschikt! U kunt in veel gevallen beter gebruik maken van iDEAL Zelfbouw.</i></span>');
	$_REQUEST['psp']['abnamro']['gateways'][] = array('code' => 'ABN Amro - iDEAL Hosted', 'type' => 'ideal', 'name' => 'iDEAL Hosted', 'dashboard' => '<b>Nieuwe iDEAL accounts</b><br>Heeft u een nieuw iDEAL account?<br>Dan moet u eerst een verplichte test procedure doorlopen eer u uw account kunt activeren. Bij deze test procedure moeten 6 test betalingen (van exact &euro; 1, &euro; 2, &euro; 3, &euro; 4, &euro; 5 en &euro; 7) worden doorlopen.<br><br>Om deze test procedure te kunnen doorlopen heeft u van de ABN Amro toegang gekregen tot een <a href="https://abnamro-test.ideal-payment.de" target="_blank" title="https://abnamro-test.ideal-payment.de">TEST dashboard</a>). Op dit dashboard vindt u o.a. uw <b>Merchant ID</b> en <b>Sub ID</b> (eigenlijk altijd "0"). Onder het tabje "Beveiliging/Security" moet u zelf een <b>Hash Key</b> instellen (alleen letters en cijfers, 12 tot 16 tekens).<br><br>Vul vervolgens hieronder bij de plug-in instellingen uw gegevens en <b>Hash Key</b> in. Sla daarna de configuratie op.<br><br>U kunt nu gebruik maken van het <a href="../test.php" target="_blank">test script</a> om de 6 verplichte testbetalingen te doorlopen. Zorg er voor dat u hierbij steeds "iDEAL" als betaalmethode kiest en het juiste test bedrag invult.<br><br>Na het doorlopen van de 6 test betalingen ziet u in uw test dashboard onder tabje "Status" dat uw test betalingen succesvol zijn doorlopen (dit kan soms een paar minuten duren i.v.m. Cache). Zolang deze vinkjes niet op groen komen te staan, kan uw account niet worden klaargezet voor activatie!<br><br>Nadat u de test procedure volledig heeft doorlopen, ontvangt u binnen 1 werkdag per e-mail een bevestiging dat u uw live account kunt activeren. U kunt daarna inloggen op uw <a href="https://abnamro.ideal-payment.de" target="_blank" title="https://abnamro.ideal-payment.de">LIVE Dashboard</a> om daar uw account te activeren (tabje: activeren).<br><br>Voor meer informatie over deze test procedure, en de 6 verplichte test betalingen kunt u contact opnemen met de ING Bank of met onze helpdesk.<br><br><br><b>Ontvangen van echte betalingen</b> (voor geactiveerde accounts)<br>Op het <a href="https://abnamro.ideal-payment.de" target="_blank" title="https://abnamro.ideal-payment.de">LIVE dashboard</a> moet u ook een <b>Hash Key</b> instellen onder tabje "Beveiliging/Security" (alleen letters en cijfers, 12 tot 16 tekens). Pas de configuratie van uw plug-in aan zodat deze nu verwijst naar de LIVE omgeving.<br><br><span class="lightbulb"><i>Let op: Deze iDEAL variant biedt een onbeveiligde terugkoppeling van de betaalstatus. Controleer daarom altijd de status betalingen via uw dashboard, internetbankieren of bankafschrift!</i></span><br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['abnamro']['gateways'][] = array('code' => 'ABN Amro - iDEAL Integrated', 'type' => 'ideal', 'name' => 'iDEAL Integrated', 'dashboard' => '<b>SSL Certificaten verkrijgen</b><br>Voor het koppelen van uw iDEAL account aan uw webshop heeft u o.a. een speciaal &quot;SSL certificaat&quot; nodig. Dit certificaat is onderdeel van de beveiliging van de communicatie met het iDEAL systeem.<br><br>Via onze online <a href="https://www.ideal-checkout.nl/ssl/ssl-automatisch-genereren" target="_blank">certificaten generator</a> kunt u deze eenvoudig zelf genereren. Na het invullen van de gewenste certificaat gegevens ontvangt u via de website een ZIP bestand met hierin 3 belangrijke bestanden ([bedrijfsnaam].cer, [bedrijfsnaam].key en [bedrijfsnaam].php). Unzip deze bestanden en upload ze via uw FTP programma in de map "[uw webshop]/idealcheckout/certificates/". U kunt deze bestanden desgewenst naar eigen inzicht hernoemen.<br><br>Houdt deze bestanden bij de hand, u heeft ze bij het configureren van de plug-in nodig!<br>- De .cer en .key bestanden heeft de plug-in nodig om uw berichten te beveiligen.<br>- Het .cer bestand heeft de bank nodig om uw berichten te controleren.<br>- Het .php bestand bevat het wachtwoord dat gebruikt is bij het genereren van het certificaat.<br><br><br><b>Nieuwe iDEAL accounts</b><br>Heeft u een nieuw iDEAL account, dan moet u eerst een verplichte test procedure doorlopen voor u uw account kunt activeren. Bij deze test procedure moeten 6 test betalingen (van exact &euro; 1, &euro; 2, &euro; 3, &euro; 4, &euro; 5 en &euro; 7) worden doorlopen.<br><br>Om deze test procedure te kunnen doorlopen heeft u van de ABN Amro toegang gekregen tot een <a href="https://abnamro-test.ideal-payment.de" target="_blank" title="https://abnamro-test.ideal-payment.de">TEST dashboard</a>). Op dit dashboard vindt u o.a. uw <b>Merchant ID</b> en <b>Sub ID</b> (eigenlijk altijd "0"). Op dit dashboard moet u tevens uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security".<br><br>Vul vervolgens hieronder bij de plug-in instellingen uw gegevens en de namen van uw .cer bestand en uw .key bestand goed in (inclusief extensie). Sla daarna de configuratie op.<br><br>U kunt nu gebruik maken van het <a href="../test.php" target="_blank">test script</a> om de 6 verplichte testbetalingen te doorlopen. Zorg er voor dat u hierbij steeds "iDEAL" als betaalmethode kiest en het juiste test bedrag invult.<br><br>Na het doorlopen van de 6 test betalingen ziet u in uw test dashboard onder tabje "Status" dat uw test betalingen succesvol zijn doorlopen (dit kan soms een paar minuten duren i.v.m. Cache). Zolang deze vinkjes niet op groen komen te staan, kan uw account niet worden klaargezet voor activatie!<br><br>Nadat u de test procedure volledig heeft doorlopen, ontvangt u binnen 1 werkdag per e-mail een bevestiging dat u uw live account kunt activeren. U kunt daarna inloggen op uw <a href="https://abnamro.ideal-payment.de" target="_blank" title="https://abnamro.ideal-payment.de">LIVE Dashboard</a> om daar uw account te activeren (tabje: activeren).<br><br>Voor meer informatie over deze test procedure, en de 6 verplichte test betalingen kunt u contact opnemen met de ABN Amro of met onze helpdesk.<br><br><br><b>Ontvangen van echte betalingen</b> (voor geactiveerde accounts)<br>Op het <a href="https://abnamro.ideal-payment.de" target="_blank" title="https://abnamro.ideal-payment.de">LIVE dashboard</a> moet u uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security". Pas de configuratie van uw plug-in aan zodat deze nu verwijst naar de LIVE omgeving.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');
	$_REQUEST['psp']['abnamro']['gateways'][] = array('code' => 'ABN Amro - iDEAL Internet Kassa', 'type' => 'ideal', 'name' => 'iDEAL Internet Kassa', 'dashboard' => 'Van uw bank/PSP heeft u toegang tot een speciaal dashboard gekregen waar u alle informatie vind om uw webshop aan de Internet Kassa te koppelen. De URL van dit dashboard is: <a href="https://internetkassa.abnamro.nl/ncol/prod/admin_ABN.asp" target="_blank">https://internetkassa.abnamro.nl/ncol/prod/admin_ABN.asp</a>.<br><br>Bij de eerste keer inloggen op dit dashboard moet u mogelijk diverse zaken configureren zoals uw contact gegevens. Heeft u vragen over dit dashboard, dan kunt u contact op nemen met de "Special Desk e-Commerce" van de ABN Amro: 020 - 383 24 94 (lokaal tarief).<br><br>Om onze plug-in goed te laten samenwerken met uw Internet Kassa account, moet u op uw dashboard een aantal beveiligingsinstellingen goed configureren. Log daarom in op uw <a href="https://internetkassa.abnamro.nl/ncol/prod/admin_ABN.asp" target="_blank">Internet Kassa Dashboard</a> en klik in het hoofdmenu op "Configureren" en daarna op "Technische Informatie".<br><br>Controleer per tabblad de volgende instellingen:<br><br>TAB: Algemene transactieparameters<br>- "Standaard operatiecode" = "Verkoop"<br>- "Verwerking van individuele transacties" = "Online maar overschakelen naar offline wanneer het online systeem van de acquirer niet beschikbaar is."<br><br>TAB: Algemene beveiligingsparameters<br>- "Stel de hash-reeks samen door de waarde samen te voegen van:" = "Elke parameter gevolgd door de passphrase."<br>- "Hash-algoritme:" = "SHA-1"<br>- "Karaktercodering:" = "ISO-8859-1"<br><br>TAB: Verificatie data en herkomst<br>- "URL van pagina van de merchant die.." = http://www.url-van-uw-webshop.nl/idealcheckout/setup.php<br>- "SHA-1-IN versleuteling" = Vul een unieke code in, bestaande uit letters en cijfers. Hoe langer hoe veiliger!<br><br>Tip: Als uw domeinnaam met en zonder "www." gebruikt kan worden, en met zowel http:// als https://, adviseren we voor elke combinatie van uw domeinnaam op te nemen in het veld "URL van pagina van de merchant die..".<br><br>TAB: Transactiefeedback<br>- "Ik wil de feedbackparameters van de transacties op de redirectie-URL\'s ontvangen." = Aanvinken<br>- "Ik wil dat Online kassa een kort redirectiebericht toont aan de klant voordat deze wordt teruggestuurd naar mijn website." = Uitvinken<br>- "SHA-1-OUT Versleuteling" = Vul een unieke code in, bestaande uit letters en cijfers, 12 tot 16 karakters<br>- "Dynamische e-commerce-parameters" = Selecteer de waarden "ORDERID", "PAYID", "PM" en "STATUS".<br><br>Neem uw PSP ID, SHA-1-IN en SHA-1-OUT key uit uw Internet Kassa Dashboard over in de onderstaande velden. Na het opslaan van de configuratie is uw webshop klaar om betalingen te ontvangen. Om uw configuratie snel te controleren kunt u gebruik maken van het <a href="../test.php" target="_blank">test script</a>.');
	$_REQUEST['psp']['abnamro']['gateways'][] = array('code' => 'ABN Amro - iDEAL Only', 'type' => 'ideal', 'name' => 'iDEAL Only', 'dashboard' => 'Van uw bank/PSP heeft u toegang tot een speciaal dashboard gekregen waar u alle informatie vind om uw webshop aan de Internet Kassa te koppelen. De URL van dit dashboard is: <a href="https://internetkassa.abnamro.nl/ncol/prod/admin_ABN.asp" target="_blank">https://internetkassa.abnamro.nl/ncol/prod/admin_ABN.asp</a>.<br><br>Bij de eerste keer inloggen op dit dashboard moet u mogelijk diverse zaken configureren zoals uw contact gegevens. Heeft u vragen over dit dashboard, dan kunt u contact op nemen met de "Special Desk e-Commerce" van de ABN Amro: 020 - 383 24 94 (lokaal tarief).<br><br>Om onze plug-in goed te laten samenwerken met uw Internet Kassa account, moet u op uw dashboard een aantal beveiligingsinstellingen goed configureren. Log daarom in op uw <a href="https://internetkassa.abnamro.nl/ncol/prod/admin_ABN.asp" target="_blank">Internet Kassa Dashboard</a> en klik in het hoofdmenu op "Configureren" en daarna op "Technische Informatie".<br><br>Controleer per tabblad de volgende instellingen:<br><br>TAB: Algemene transactieparameters<br>- "Standaard operatiecode" = "Verkoop"<br>- "Verwerking van individuele transacties" = "Online maar overschakelen naar offline wanneer het online systeem van de acquirer niet beschikbaar is."<br><br>TAB: Algemene beveiligingsparameters<br>- "Stel de hash-reeks samen door de waarde samen te voegen van:" = "Elke parameter gevolgd door de passphrase."<br>- "Hash-algoritme:" = "SHA-1"<br>- "Karaktercodering:" = "ISO-8859-1"<br><br>TAB: Verificatie data en herkomst<br>- "URL van pagina van de merchant die.." = http://www.url-van-uw-webshop.nl/idealcheckout/setup.php<br>- "SHA-1-IN versleuteling" = Vul een unieke code in, bestaande uit letters en cijfers. Hoe langer hoe veiliger!<br><br>Tip: Als uw domeinnaam met en zonder "www." gebruikt kan worden, en met zowel http:// als https://, adviseren we voor elke combinatie van uw domeinnaam op te nemen in het veld "URL van pagina van de merchant die..".<br><br>TAB: Transactiefeedback<br>- "Ik wil de feedbackparameters van de transacties op de redirectie-URL\'s ontvangen." = Aanvinken<br>- "Ik wil dat Online kassa een kort redirectiebericht toont aan de klant voordat deze wordt teruggestuurd naar mijn website." = Uitvinken<br>- "SHA-1-OUT Versleuteling" = Vul een unieke code in, bestaande uit letters en cijfers, 12 tot 16 karakters<br>- "Dynamische e-commerce-parameters" = Selecteer de waarden "ORDERID", "PAYID", "PM" en "STATUS".<br><br>Neem uw PSP ID, SHA-1-IN en SHA-1-OUT key uit uw Internet Kassa Dashboard over in de onderstaande velden. Na het opslaan van de configuratie is uw webshop klaar om betalingen te ontvangen. Om uw configuratie snel te controleren kunt u gebruik maken van het <a href="../test.php" target="_blank">test script</a>.');
	$_REQUEST['psp']['abnamro']['gateways'][] = array('code' => 'ABN Amro - iDEAL Zelfbouw', 'type' => 'ideal', 'name' => 'iDEAL Zelfbouw', 'dashboard' => '<b>SSL Certificaten verkrijgen</b><br>Voor het koppelen van uw iDEAL account aan uw webshop heeft u o.a. een speciaal &quot;SSL certificaat&quot; nodig. Dit certificaat is onderdeel van de beveiliging van de communicatie met het iDEAL systeem.<br><br>Via onze online <a href="https://www.ideal-checkout.nl/ssl/ssl-automatisch-genereren" target="_blank">certificaten generator</a> kunt u deze eenvoudig zelf genereren. Na het invullen van de gewenste certificaat gegevens ontvangt u via de website een ZIP bestand met hierin 3 belangrijke bestanden ([bedrijfsnaam].cer, [bedrijfsnaam].key en [bedrijfsnaam].php). Unzip deze bestanden en upload ze via uw FTP programma in de map "[uw webshop]/idealcheckout/certificates/". U kunt deze bestanden desgewenst naar eigen inzicht hernoemen.<br><br>Houdt deze bestanden bij de hand, u heeft ze bij het configureren van de plug-in nodig!<br>- De .cer en .key bestanden heeft de plug-in nodig om uw berichten te beveiligen.<br>- Het .cer bestand heeft de bank nodig om uw berichten te controleren.<br>- Het .php bestand bevat het wachtwoord dat gebruikt is bij het genereren van het certificaat.<br><br><br><b>Nieuwe iDEAL accounts</b><br>Heeft u een nieuw iDEAL account, dan moet u eerst een verplichte test procedure doorlopen voor u uw account kunt activeren. Bij deze test procedure moeten 6 test betalingen (van exact &euro; 1, &euro; 2, &euro; 3, &euro; 4, &euro; 5 en &euro; 7) worden doorlopen.<br><br>Om deze test procedure te kunnen doorlopen heeft u van de ABN Amro toegang gekregen tot een <a href="https://abnamro-test.ideal-payment.de" target="_blank" title="https://abnamro-test.ideal-payment.de">TEST dashboard</a>). Op dit dashboard vindt u o.a. uw <b>Merchant ID</b> en <b>Sub ID</b> (eigenlijk altijd "0"). Op dit dashboard moet u tevens uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security".<br><br>Vul vervolgens hieronder bij de plug-in instellingen uw gegevens en de namen van uw .cer bestand en uw .key bestand goed in (inclusief extensie). Sla daarna de configuratie op.<br><br>U kunt nu gebruik maken van het <a href="../test.php" target="_blank">test script</a> om de 6 verplichte testbetalingen te doorlopen. Zorg er voor dat u hierbij steeds "iDEAL" als betaalmethode kiest en het juiste test bedrag invult.<br><br>Na het doorlopen van de 6 test betalingen ziet u in uw test dashboard onder tabje "Status" dat uw test betalingen succesvol zijn doorlopen (dit kan soms een paar minuten duren i.v.m. Cache). Zolang deze vinkjes niet op groen komen te staan, kan uw account niet worden klaargezet voor activatie!<br><br>Nadat u de test procedure volledig heeft doorlopen, ontvangt u binnen 1 werkdag per e-mail een bevestiging dat u uw live account kunt activeren. U kunt daarna inloggen op uw <a href="https://abnamro.ideal-payment.de" target="_blank" title="https://abnamro.ideal-payment.de">LIVE Dashboard</a> om daar uw account te activeren (tabje: activeren).<br><br>Voor meer informatie over deze test procedure, en de 6 verplichte test betalingen kunt u contact opnemen met de ABN Amro of met onze helpdesk.<br><br><br><b>Ontvangen van echte betalingen</b> (voor geactiveerde accounts)<br>Op het <a href="https://abnamro.ideal-payment.de" target="_blank" title="https://abnamro.ideal-payment.de">LIVE dashboard</a> moet u uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security". Pas de configuratie van uw plug-in aan zodat deze nu verwijst naar de LIVE omgeving.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');

	$_REQUEST['psp']['easyideal']['name'] = 'Easy iDEAL';
	$_REQUEST['psp']['easyideal']['gateways'] = array();
	$_REQUEST['psp']['easyideal']['gateways'][] = array('code' => 'Easy iDEAL - iDEAL', 'type' => 'ideal', 'name' => 'iDEAL', 'dashboard' => 'Om een koppeling met Qantani te configureren heeft u een <b>Merchant ID</b>, een <b>Merchant Key</b> en een <b>Merchant Secret</b> nodig.<br><br>Deze vindt u in uw Qantani dashboard op <a href="https://www.qantanipayments.com" target="_blank">https://www.qantanipayments.com</a>');

	
	$_REQUEST['psp']['ingbank']['name'] = 'ING Bank';
	$_REQUEST['psp']['ingbank']['gateways'] = array();
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Bank - iDEAL Advanced', 'type' => 'ideal', 'name' => 'iDEAL Advanced', 'dashboard' => '<b>SSL Certificaten verkrijgen</b><br>Voor het koppelen van uw iDEAL account aan uw webshop heeft u o.a. een speciaal &quot;SSL certificaat&quot; nodig. Dit certificaat is onderdeel van de beveiliging van de communicatie met het iDEAL systeem.<br><br>Via onze online <a href="https://www.ideal-checkout.nl/ssl/ssl-automatisch-genereren" target="_blank">certificaten generator</a> kunt u deze eenvoudig zelf genereren. Na het invullen van de gewenste certificaat gegevens ontvangt u via de website een ZIP bestand met hierin 3 belangrijke bestanden ([bedrijfsnaam].cer, [bedrijfsnaam].key en [bedrijfsnaam].php). Unzip deze bestanden en upload ze via uw FTP programma in de map "[uw webshop]/idealcheckout/certificates/". U kunt deze bestanden desgewenst naar eigen inzicht hernoemen.<br><br>Houdt deze bestanden bij de hand, u heeft ze bij het configureren van de plug-in nodig!<br>- De .cer en .key bestanden heeft de plug-in nodig om uw berichten te beveiligen.<br>- Het .cer bestand heeft de bank nodig om uw berichten te controleren.<br>- Het .php bestand bevat het wachtwoord dat gebruikt is bij het genereren van het certificaat.<br><br><br><b>Nieuwe iDEAL accounts</b><br>Heeft u een nieuw iDEAL account, dan moet u eerst een verplichte test procedure doorlopen voor u uw account kunt activeren. Bij deze test procedure moeten 6 test betalingen (van exact &euro; 1, &euro; 2, &euro; 3, &euro; 4, &euro; 5 en &euro; 7) worden doorlopen.<br><br>Om deze test procedure te kunnen doorlopen heeft u van de ING Bank toegang gekregen tot een <a href="https://idealtest.secure-ing.com" target="_blank" title="https://idealtest.secure-ing.com">TEST dashboard</a>). Op dit dashboard vindt u o.a. uw <b>Merchant ID</b> en <b>Sub ID</b> (eigenlijk altijd "0"). Op dit dashboard moet u tevens uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security".<br><br>Vul vervolgens hieronder bij de plug-in instellingen uw gegevens en de namen van uw .cer bestand en uw .key bestand goed in (inclusief extensie). Sla daarna de configuratie op.<br><br>U kunt nu gebruik maken van het <a href="../test.php" target="_blank">test script</a> om de 6 verplichte testbetalingen te doorlopen. Zorg er voor dat u hierbij steeds "iDEAL" als betaalmethode kiest en het juiste test bedrag invult.<br><br>Na het doorlopen van de 6 test betalingen ziet u in uw test dashboard onder tabje "Status" dat uw test betalingen succesvol zijn doorlopen (dit kan soms een paar minuten duren i.v.m. Cache). Zolang deze vinkjes niet op groen komen te staan, kan uw account niet worden klaargezet voor activatie!<br><br>Nadat u de test procedure volledig heeft doorlopen, ontvangt u binnen 1 werkdag per e-mail een bevestiging dat u uw live account kunt activeren. U kunt daarna inloggen op uw <a href="https://ideal.secure-ing.com" target="_blank" title="https://ideal.secure-ing.com">LIVE Dashboard</a> om daar uw account te activeren (tabje: activeren).<br><br>Voor meer informatie over deze test procedure, en de 6 verplichte test betalingen kunt u contact opnemen met de ING Bank of met onze helpdesk.<br><br><br><b>Ontvangen van echte betalingen</b> (voor geactiveerde accounts)<br>Op het <a href="https://ideal.secure-ing.com" target="_blank" title="https://ideal.secure-ing.com">LIVE dashboard</a> moet u uw certificaat (het .cer bestand uit de ZIP) uploaden onder tabje "Beveiliging/Security". Pas de configuratie van uw plug-in aan zodat deze nu verwijst naar de LIVE omgeving.<br><br><br>&nbsp;<h3>Plug-in instellingen</h3>Vul onderstaande gegevens in om uw plug-in te configureren.');

	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - ALL', 'type' => 'ideal', 'name' => 'Kassa Compleet - ALL', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - iDEAL', 'type' => 'ideal', 'name' => 'Kassa Compleet - iDEAL', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - Creditcard', 'type' => 'creditcard', 'name' => 'Kassa Compleet - Creditcard', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - Handmatige overboeking', 'type' => 'manualtransfer', 'name' => 'Kassa Compleet - Handmatige overboeking', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in..');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - Bancontact', 'type' => 'bancontact', 'name' => 'Kassa Compleet - Bancontact', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - PayPal', 'type' => 'paypal', 'name' => 'Kassa Compleet - PayPal', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - Klarna', 'type' => 'klarnainvoice', 'name' => 'Kassa Compleet - Klarna (invoice)', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - Payconiq', 'type' => 'payconiq', 'name' => 'Kassa Compleet - Payconiq', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Kassa compleet - Afterpay', 'type' => 'afterpay', 'name' => 'Kassa Compleet - Afterpay', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.kassacompleet.nl" target="_blank">Kassa Compleet dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');

	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - ALL', 'type' => 'ideal', 'name' => 'ING Checkout - ALL', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - iDEAL', 'type' => 'ideal', 'name' => 'ING Checkout - iDEAL', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - Creditcard', 'type' => 'creditcard', 'name' => 'ING Checkout - Creditcard', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - Handmatige overboeking', 'type' => 'manualtransfer', 'name' => 'ING Checkout - Handmatige overboeking', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - Bancontact', 'type' => 'bancontact', 'name' => 'ING Checkout - Bancontact', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - PayPal', 'type' => 'paypal', 'name' => 'ING Checkout - PayPal', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - Klarna', 'type' => 'klarnainvoice', 'name' => 'ING Checkout - Klarna  (invoice)', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - Sofort', 'type' => 'sofort', 'name' => 'ING Checkout - Sofort', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - Payconiq', 'type' => 'payconiq', 'name' => 'ING Checkout - Payconiq', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING Checkout - Afterpay', 'type' => 'afterpay', 'name' => 'ING Checkout - Afterpay', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING Checkout dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');

	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING ePAY - ALL', 'type' => 'ideal', 'name' => 'ING ePAY - ALL', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING ePAY dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING ePAY - iDEAL', 'type' => 'ideal', 'name' => 'ING ePAY - iDEAL', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING ePAY dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING ePAY - Creditcard', 'type' => 'creditcard', 'name' => 'ING ePAY - Creditcard', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING ePAY dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING ePAY - Handmatige overboeking', 'type' => 'manualtransfer', 'name' => 'ING ePAY - Handmatige overboeking', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING ePAY dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');
	$_REQUEST['psp']['ingbank']['gateways'][] = array('code' => 'ING ePAY - Bancontact', 'type' => 'bancontact', 'name' => 'ING ePAY - Bancontact', 'dashboard' => '<b>API Key ophalen</b><br> Voor de configuratie van de plug-in bent u de API key nodig. Deze vind u door naar uw <a href="https://portal.ing-checkout.nl" target="_blank">ING ePAY dashboard</a> te gaan. Hier gaat u vervolgens naar de instellingen pagina, hier klikt u vervolgens op webwinkels. Hier selecteert u de webshop waarvoor de plugin moet worden geïnstalleerd. Hier vind u links onderin een knop "Klik hier voor de API key" Kopieër deze key en vul deze hieronder in.');


	$_REQUEST['psp']['qantani']['name'] = 'Qantani';
	$_REQUEST['psp']['qantani']['gateways'] = array();
	$_REQUEST['psp']['qantani']['gateways'][] = array('code' => 'Qantani - Creditcard', 'type' => 'creditcard', 'name' => 'Creditcard', 'dashboard' => 'Om een koppeling met Qantani te configureren heeft u een <b>Merchant ID</b>, een <b>Merchant Key</b> en een <b>Merchant Secret</b> nodig.<br><br>Deze vindt u in uw Qantani dashboard op <a href="https://www.qantanipayments.com" target="_blank">https://www.qantanipayments.com</a>');
	$_REQUEST['psp']['qantani']['gateways'][] = array('code' => 'Qantani - Sofortbanking', 'type' => 'sofortbanking', 'name' => 'Sofortbanking', 'dashboard' => 'Om een koppeling met Qantani te configureren heeft u een <b>Merchant ID</b>, een <b>Merchant Key</b> en een <b>Merchant Secret</b> nodig.<br><br>Deze vindt u in uw Qantani dashboard op <a href="https://www.qantanipayments.com" target="_blank">https://www.qantanipayments.com</a>');
	$_REQUEST['psp']['qantani']['gateways'][] = array('code' => 'Qantani - iDEAL', 'type' => 'ideal', 'name' => 'iDEAL', 'dashboard' => 'Om een koppeling met Qantani te configureren heeft u een <b>Merchant ID</b>, een <b>Merchant Key</b> en een <b>Merchant Secret</b> nodig.<br><br>Deze vindt u in uw Qantani dashboard op <a href="https://www.qantanipayments.com" target="_blank">https://www.qantanipayments.com</a>');
	$_REQUEST['psp']['qantani']['gateways'][] = array('code' => 'Qantani - PayPal', 'type' => 'paypal', 'name' => 'PayPal', 'dashboard' => 'Om een koppeling met Qantani te configureren heeft u een <b>Merchant ID</b>, een <b>Merchant Key</b> en een <b>Merchant Secret</b> nodig.<br><br>Deze vindt u in uw Qantani dashboard op <a href="https://www.qantanipayments.com" target="_blank">https://www.qantanipayments.com</a>');


	$_REQUEST['psp']['targetpay']['name'] = 'TargetPay';
	$_REQUEST['psp']['targetpay']['gateways'] = array();
	$_REQUEST['psp']['targetpay']['gateways'][] = array('code' => 'TargetPay - Creditcard', 'type' => 'creditcard', 'name' => 'Creditcard', 'dashboard' => 'Om een koppeling met TargetPay te configureren heeft u een LayoutCode nodig.<br><br>Deze vindt u in uw TargetPay dashboard op <a href="https://www.targetpay.com/login" target="_blank">https://www.targetpay.com/login</a>');
	$_REQUEST['psp']['targetpay']['gateways'][] = array('code' => 'TargetPay - Sofortbanking', 'type' => 'sofortbanking', 'name' => 'Sofortbanking', 'dashboard' => 'Om een koppeling met TargetPay te configureren heeft u een LayoutCode nodig.<br><br>Deze vindt u in uw TargetPay dashboard op <a href="https://www.targetpay.com/login" target="_blank">https://www.targetpay.com/login</a>');
	$_REQUEST['psp']['targetpay']['gateways'][] = array('code' => 'TargetPay - iDEAL', 'type' => 'ideal', 'name' => 'iDEAL', 'dashboard' => 'Om een koppeling met TargetPay te configureren heeft u een LayoutCode nodig.<br><br>Deze vindt u in uw TargetPay dashboard op <a href="https://www.targetpay.com/login" target="_blank">https://www.targetpay.com/login</a>');
	$_REQUEST['psp']['targetpay']['gateways'][] = array('code' => 'TargetPay - Bancontact', 'type' => 'bancontact', 'name' => 'Bancontact / Bancontact', 'dashboard' => 'Om een koppeling met TargetPay te configureren heeft u een LayoutCode nodig.<br><br>Deze vindt u in uw TargetPay dashboard op <a href="https://www.targetpay.com/login" target="_blank">https://www.targetpay.com/login</a>');
	$_REQUEST['psp']['targetpay']['gateways'][] = array('code' => 'TargetPay - PaySafeCard', 'type' => 'paysafecard', 'name' => 'PaySafeCard', 'dashboard' => 'Om een koppeling met TargetPay te configureren heeft u een LayoutCode nodig.<br><br>Deze vindt u in uw TargetPay dashboard op <a href="https://www.targetpay.com/login" target="_blank">https://www.targetpay.com/login</a>');

	$_REQUEST['psp']['paydutch']['name'] = 'PayDutch / Dutch Payment Group';
	$_REQUEST['psp']['paydutch']['gateways'] = array();
	$_REQUEST['psp']['paydutch']['gateways'][] = array('code' => 'PayDutch - Sofortbanking', 'type' => 'sofortbanking', 'name' => 'Sofortbanking', 'dashboard' => 'Om een koppeling met PayDutch te configureren heeft u onderstaande gegevens nodig.<br>Deze vindt u in uw PayDutch dashboard op <a href="https://www.paydutch.nl/PaydutchManager" target="_blank">https://www.paydutch.nl/PaydutchManager</a>');
	$_REQUEST['psp']['paydutch']['gateways'][] = array('code' => 'PayDutch - WeDeal', 'type' => 'ideal', 'name' => 'WeDeal', 'dashboard' => 'Om een koppeling met PayDutch te configureren heeft u onderstaande gegevens nodig.<br>Deze vindt u in uw PayDutch dashboard op <a href="https://www.paydutch.nl/PaydutchManager" target="_blank">https://www.paydutch.nl/PaydutchManager</a>');

?>
