<?php

	class IDEALCHECKOUT_FOR_CS_CART_4_0_0
	{
		// Return the software name
		public static function getSoftwareName()
		{
			return 'CS Cart 4.0.0+';
		}



		// Return the software code
		public static function getSoftwareCode()
		{
			return str_replace('_', '-', substr(basename(__FILE__), 0, -4));
		}



		// Return path to main cinfig file (if any)
		public static function getConfigFile()
		{
			return SOFTWARE_PATH . DS . 'config.local.php';
		}



		// Return path to main cinfig file (if any)
		public static function getConfigData()
		{
			$sConfigFile = self::getConfigFile();

			// Detect DB settings via configuration file
			if(is_file($sConfigFile))
			{
				return file_get_contents($sConfigFile);
			}

			return '';
		}



		// Find default database settings
		public static function getDatabaseSettings($aSettings)
		{
			$aSettings['db_prefix'] = 'cscart_';
			$sConfigData = self::getConfigData();

			if(!empty($sConfigData))
			{
				$aSettings['db_host'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/\$config\[\'db_host\'\] = \'([^\']+)\';/');
				$aSettings['db_user'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/\$config\[\'db_user\'\] = \'([^\']+)\';/');
				$aSettings['db_pass'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/\$config\[\'db_password\'\] = \'([^\']+)\';/');
				$aSettings['db_name'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/\$config\[\'db_name\'\] = \'([^\']+)\';/');
				$aSettings['db_prefix'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/\$config\[\'table_prefix\'\] = \'([^\']+)\';/');
				$aSettings['db_type'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/\$config\[\'database_backend\'\] = \'([^\']+)\';/');
			}

			return $aSettings;
		}



		// See if current software == self::$sSoftwareCode
		public static function isSoftware()
		{
			$aFiles = array();
			$aFiles[] = SOFTWARE_PATH . DS . 'config.local.php';

			$aFiles[] = SOFTWARE_PATH . DS . 'app';
			$aFiles[] = SOFTWARE_PATH . DS . 'var';

			$aFiles[] = SOFTWARE_PATH . DS . 'api.php';
			$aFiles[] = SOFTWARE_PATH . DS . 'config.php';

			foreach($aFiles as $sFile)
			{
				if(!is_file($sFile) && !is_dir($sFile))
				{
					return false;
				}
			}

			return true;
		}




		// Install plugin, return text
		public static function doInstall($aSettings)
		{
			IDEALCHECKOUT_INSTALL::doInstall($aSettings);



			$sql = "SELECT `processor_script` FROM `" . $aSettings['db_prefix'] . "payment_processors` WHERE `processor_script` LIKE '%idealcheckout%' LIMIT 1;";
			if(!idealcheckout_database_isRecord($sql)) // See if key was already added
			{
				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1001', `processor` = 'iDEAL Checkout - iDEAL', `processor_script` = 'idealcheckoutideal.php', `processor_template` = 'views/orders/components/payments/idealcheckoutideal.tpl', `admin_template` = 'idealcheckoutideal.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1002', `processor` = 'iDEAL Checkout - Mister Cash', `processor_script` = 'idealcheckoutmistercash.php', `processor_template` = 'views/orders/components/payments/idealcheckoutmistercash.tpl', `admin_template` = 'idealcheckoutmistercash.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1003', `processor` = 'iDEAL Checkout - Bancontact', `processor_script` = 'idealcheckoutbancontact.php', `processor_template` = 'views/orders/components/payments/idealcheckoutbancontact.tpl', `admin_template` = 'idealcheckoutbancontact.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1004', `processor` = 'iDEAL Checkout - Credit Card', `processor_script` = 'idealcheckoutcreditcard.php', `processor_template` = 'views/orders/components/payments/idealcheckoutcreditcard.tpl', `admin_template` = 'idealcheckoutcreditcard.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1006', `processor` = 'iDEAL Checkout - PayPal', `processor_script` = 'idealcheckoutpaypal.php', `processor_template` = 'views/orders/components/payments/idealcheckoutpaypal.tpl', `admin_template` = 'idealcheckoutpaypal.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1007', `processor` = 'iDEAL Checkout - PaySafeCard', `processor_script` = 'idealcheckoutpaysafecard.php', `processor_template` = 'views/orders/components/payments/idealcheckoutpaysafecard.tpl', `admin_template` = 'idealcheckoutsafecard.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1009', `processor` = 'iDEAL Checkout - AuthorizedTransfer', `processor_script` = 'idealcheckoutauthorizedtransfer.php', `processor_template` = 'views/orders/components/payments/idealcheckoutauthorizedtransfer.tpl', `admin_template` = 'idealcheckoutauthorizedtransfer.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1016', `processor` = 'iDEAL Checkout - Maestro', `processor_script` = 'idealcheckoutmaestro.php', `processor_template` = 'views/orders/components/payments/idealcheckoutmaestro.tpl', `admin_template` = 'idealcheckoutmaestro.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1017', `processor` = 'iDEAL Checkout - ManualTransfer', `processor_script` = 'idealcheckoutmanualtransfer.php', `processor_template` = 'views/orders/components/payments/idealcheckoutmanualtransfer.tpl', `admin_template` = 'idealcheckoutmanualtransfer.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1018', `processor` = 'iDEAL Checkout - MasterCard', `processor_script` = 'idealcheckoutmastercard.php', `processor_template` = 'views/orders/components/payments/idealcheckoutmastercard.tpl', `admin_template` = 'idealcheckoutmastercard.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1020', `processor` = 'iDEAL Checkout - Visa', `processor_script` = 'idealcheckoutvisa.php', `processor_template` = 'views/orders/components/payments/idealcheckoutvisa.tpl', `admin_template` = 'idealcheckoutvisa.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1021', `processor` = 'iDEAL Checkout - VPay', `processor_script` = 'idealcheckoutvpay.php', `processor_template` = 'views/orders/components/payments/idealcheckoutvpay.tpl', `admin_template` = 'idealcheckoutvpay.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1022', `processor` = 'iDEAL Checkout - Klarna account', `processor_script` = 'idealcheckoutklarnaaccount.php', `processor_template` = 'views/orders/components/payments/idealcheckoutklarnaaccount.tpl', `admin_template` = 'idealcheckoutklarnaaccount.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1023', `processor` = 'iDEAL Checkout - Klarna invoice', `processor_script` = 'idealcheckoutklarnainvoice.php', `processor_template` = 'views/orders/components/payments/idealcheckoutklarnainvoice.tpl', `admin_template` = 'idealcheckoutklarnainvoice.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1024', `processor` = 'iDEAL Checkout - Payconiq', `processor_script` = 'idealcheckoutpayconiq.php', `processor_template` = 'views/orders/components/payments/idealcheckoutpayconiq.tpl', `admin_template` = 'idealcheckoutpayconiq.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1025', `processor` = 'iDEAL Checkout - Klarnabuynow', `processor_script` = 'idealcheckoutklarnabuynow.php', `processor_template` = 'views/orders/components/payments/idealcheckoutklarnabuynow.tpl', `admin_template` = 'idealcheckoutklarnabuynow.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "payment_processors` SET `processor_id` = '1026', `processor` = 'iDEAL Checkout - Sofort Banking', `processor_script` = 'idealcheckoutsofortbanking.php', `processor_template` = 'views/orders/components/payments/idealcheckoutsofortbanking.tpl', `admin_template` = 'idealcheckoutsofortbanking.tpl', `callback` = 'N', `type` = 'P'";
				idealcheckout_database_execute($sql);
			}
			
			
			$sql = "SHOW COLUMNS FROM `" . $aSettings['db_prefix'] . "idealcheckout_settings` LIKE `webshop_package`";
			
			if(!$aColumn = idealcheckout_database_getRecord($sql))
			{
				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`id` = NULL, 
`keyname` = 'webshop_package',
`value` = 'cs-cart'";
				idealcheckout_database_execute($sql);
				
			}
			else
			{
				$sql = "UPDATE `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`value` = 'cs-cart' WHERE (`keyname` = 'webshop_package') LIMIT 1";
				idealcheckout_database_execute($sql);
			}
			
			
			


			return true;
		}



		// Install plugin, return text
		public static function getInstructions($aSettings)
		{
			$sHtml = '';
			$sHtml .= '<ol>';
			$sHtml .= '<li>Log in op de beheeromgeving van uw webshop.</li>';
			$sHtml .= '<li>Ga naar Administration / Payment Methods.</li>';
			$sHtml .= '<li>Klik op de knop "Add Payment".</li>';
			$sHtml .= '<li>Vul bij het veld "Name/Naam" de waarde "iDEAL" in en bij het veld "Processor/Verwerkingseenheid" de waarde "iDEAL Checkout - iDEAL". Klik daarna op de "Create"-knop.</li>';
			$sHtml .= '<li>Herhaal stap 3 en 4 voor de overige betaalmethoden die u wilt aanbieden in uw webshop.</li>';
			$sHtml .= '</ol>';

			return $sHtml;
		}
	}

?>