<?php

	require_once(dirname(dirname(__FILE__)) . '/gateway.core.cls.5.php');
	require_once(dirname(__FILE__) . '/cashflows.cls.php');


	class Gateway extends GatewayCore
	{
		const PAYMENT_METHOD = 'creditcard';

		// Load iDEAL settings
		public function __construct()
		{
			$this->init();
		}

		// Setup payment
		public function doSetup()
		{
			global $aIdealCheckout;

			$sHtml = '';

			// Look for proper GET's en POST's
			if(empty($_GET['order_id']) || empty($_GET['order_code']))
			{
				$sHtml .= '<p>Invalid transaction request.</p>';
			}
			else
			{
				$sOrderId = $_GET['order_id'];
				$sOrderCode = $_GET['order_code'];


				// Lookup transaction
				if($this->getRecordByOrder())
				{
					if(strcmp($this->oRecord['transaction_status'], 'SUCCESS') === 0)
					{
						$sHtml .= '<p>Transaction already completed</p>';
					}
					elseif((strcmp($this->oRecord['transaction_status'], 'OPEN') === 0) && !empty($this->oRecord['transaction_url']))
					{
						header('Location: ' . $this->oRecord['transaction_url']);
						exit;
					}
					else
					{
						$sReturnUrl = idealcheckout_getRootUrl(1) . 'idealcheckout/return.php?order_id=' . $this->oRecord['order_id'] . '&order_code=' . $this->oRecord['order_code'];
						$sReportUrl = idealcheckout_getRootUrl(1) . 'idealcheckout/report.php?order_id=' . $this->oRecord['order_id'] . '&order_code=' . $this->oRecord['order_code'];
						// $sReportUrl = idealcheckout_getRootUrl(1) . 'idealcheckout/report.php';
						$sLanguageCode = (empty($this->oRecord['language_code']) ? 'nl' : $this->oRecord['language_code']);

						$oCashflows = new CashflowsPayment($this->aSettings['API_KEY'], $this->aSettings['CONFIGURATION_ID']);

						if(!empty($this->aSettings['TEST_MODE']))
						{
							$oCashflows->setTestmode(true);
						}

						$oCashflows->setPaymentMethod(self::PAYMENT_METHOD);
						$oCashflows->setLocale('nl_NL');
						$oCashflows->setOrderId($this->oRecord['order_id']);
						$oCashflows->setOrderDescription($this->oRecord['order_id'], $this->oRecord['transaction_description']);
						$oCashflows->setOrderAmount($this->oRecord['transaction_amount']);
						$oCashflows->setCurrencyCode($this->oRecord['currency_code']);
						$oCashflows->setReturnUrl($sReturnUrl);
						$oCashflows->setReportUrl($sReportUrl);

						if($oCashflows->getTransaction())
						{
							$this->oRecord['transaction_params'] = $oCashflows->getJsonResponse();
							$this->oRecord['transaction_url'] = $oCashflows->getTransactionUrl();
							$this->oRecord['transaction_status'] = 'PENDING';

							if(empty($this->oRecord['transaction_log']) == false)
							{
								$this->oRecord['transaction_log'] .= "\n\n";
							}

							$this->oRecord['transaction_log'] .= 'Requesting transaction on ' . date('Y-m-d, H:i:s') . '; recieved ID: "' . $this->oRecord['transaction_id'] . '" and URL: "' . $this->oRecord['transaction_url'] . '".';
							$this->save();

							header('Location: ' . $this->oRecord['transaction_url']);
							exit;
						}
						else
						{
							$sHtml .= '<p>' . $oCashflows->getJsonResponse() . '</p>';
						}
					}
				}
				else
				{
					$sHtml .= '<p>Invalid transaction request.</p>';
				}
			}

			idealcheckout_output($sHtml);
		}


		// Catch return
		public function doReturn()
		{
			$sHtml = '';

			if(empty($_GET['order_id']) || empty($_GET['order_code']) && empty($_GET['paymentjobref']))
			{
				$sHtml .= '<p>Invalid return request.</p>';
			}
			else
			{
				$sPaymentJobReference = $_GET['paymentjobref'];

				// Lookup record
				if($this->getRecordByOrder())
				{
					// Verify status
					$oCashflows = new CashflowsPayment($this->aSettings['API_KEY'], $this->aSettings['CONFIGURATION_ID']);

					if(!empty($this->aSettings['TEST_MODE']))
					{
						$oCashflows->setTestmode(true);
					}

					if(strcmp($this->oRecord['transaction_status'], 'SUCCESS') !== 0)
					{
						$sTransactionStatus = $oCashflows->getStatus($sPaymentJobReference);

						$this->oRecord['transaction_status'] = $sTransactionStatus;
						$this->oRecord['transaction_params'] = $oCashflows->getJsonResponse();

						if(empty($this->oRecord['transaction_log']) == false)
						{
							$this->oRecord['transaction_log'] .= "\n\n";
						}

						$this->oRecord['transaction_log'] .= 'Executing StatusRequest on ' . date('Y-m-d, H:i:s') . ' for #' . $this->oRecord['transaction_id'] . '. Recieved: ' . $this->oRecord['transaction_status'];

						$this->save();

						// Handle status change
						if(function_exists('idealcheckout_update_order_status'))
						{
							idealcheckout_update_order_status($this->oRecord, 'doReturn');
						}

						// Set status message
						if(in_array($this->oRecord['transaction_status'], array('SUCCESS')))
						{
							if(!empty($this->oRecord['transaction_success_url']))
							{
								header('Location: ' . $this->oRecord['transaction_success_url']);
								exit;
							}

							$sHtml .= '<p>Uw betaling is met succes ontvangen.<br><input style="margin: 6px;" type="button" value="Terug naar de website" onclick="javascript: document.location.href = \'' . htmlspecialchars(idealcheckout_getRootUrl(1)) . '\'"></p>';
						}
						elseif(in_array($this->oRecord['transaction_status'], array('OPEN', 'PENDING')))
						{
							if(!empty($this->oRecord['transaction_pending_url']))
							{
								header('Location: ' . $this->oRecord['transaction_pending_url']);
								exit;
							}

							$sHtml .= '<p>Uw betaling is in behandeling.<br><input style="margin: 6px;" type="button" value="Terug naar de website" onclick="javascript: document.location.href = \'' . htmlspecialchars(idealcheckout_getRootUrl(1)) . '\'"></p>';
						}
						elseif(in_array($this->oRecord['transaction_status'], array('CANCELLED')))
						{
							if(!empty($this->oRecord['transaction_failure_url']))
							{
								header('Location: ' . $this->oRecord['transaction_failure_url']);
								exit;
							}

							$sHtml .= '<p>Uw betaling is geannuleerd. Probeer opnieuw te betalen.<br><input style="margin: 6px;" type="button" value="Verder" onclick="javascript: document.location.href = \'' . htmlspecialchars(idealcheckout_getRootUrl(1) . 'idealcheckout/setup.php?order_id=' . $this->oRecord['order_id'] . '&order_code=' . $this->oRecord['order_code']) . '\'"></p>';
						}
						else // if(strcasecmp($this->oRecord['transaction_status'], 'FAILURE') === 0)
						{
							if(!empty($this->oRecord['transaction_failure_url']))
							{
								header('Location: ' . $this->oRecord['transaction_failure_url']);
								exit;
							}

							$sHtml .= '<p>Uw betaling is mislukt. Probeer opnieuw te betalen.<br><input style="margin: 6px;" type="button" value="Verder" onclick="javascript: document.location.href = \'' . htmlspecialchars(idealcheckout_getRootUrl(1) . 'idealcheckout/setup.php?order_id=' . $this->oRecord['order_id'] . '&order_code=' . $this->oRecord['order_code']) . '\'"></p>';
						}
					}
					else
					{
						$sHtml .= '<p>Status SUCCESS already found, payment already processed.</p>';
					}
				}
				else
				{
					$sHtml .= '<p>Invalid return request.</p>';
				}
			}

			idealcheckout_output($sHtml);
		}


		// Catch report
		public function doReport()
		{
			$sHtml = '';

			$sJsonData = @file_get_contents('php://input');

			if(empty($sJsonData))
			{
				$sHtml .= '<p>Invalid notification call.</p>';
			}
			else
			{
				$aPostData = json_decode($sJsonData, true);

				$sPaymentJobReference = $aPostData['paymentJobReference'];

				if($this->getRecordByOrder())
				{
					// Verify status
					$oCashflows = new CashflowsPayment($this->aSettings['API_KEY'], $this->aSettings['CONFIGURATION_ID']);

					if(!empty($this->aSettings['TEST_MODE']))
					{
						$oCashflows->setTestmode(true);
					}

					if(strcmp($this->oRecord['transaction_status'], 'SUCCESS') !== 0)
					{
						$sTransactionStatus = $oCashflows->getStatus($sPaymentJobReference);

						$this->oRecord['transaction_status'] = $sTransactionStatus;
						$this->oRecord['transaction_params'] = $oCashflows->getJsonResponse();

						if(empty($this->oRecord['transaction_log']) == false)
						{
							$this->oRecord['transaction_log'] .= "\n\n";
						}

						$this->oRecord['transaction_log'] .= 'Executing Callback StatusRequest on ' . date('Y-m-d, H:i:s') . ' for #' . $sPaymentJobReference . '. Recieved: ' . $this->oRecord['transaction_status'];

						$this->save();

						// Handle status change
						if(function_exists('idealcheckout_update_order_status'))
						{
							idealcheckout_update_order_status($this->oRecord, 'doReport');
						}
						else
						{
							if(in_array($this->oRecord['transaction_status'], array('SUCCESS')))
							{
								if(!empty($this->oRecord['transaction_success_url']))
								{
									idealcheckout_log('Calling success URL: ' . $this->oRecord['transaction_success_url'], __FILE__, __LINE__);
									idealcheckout_doHttpRequest($this->oRecord['transaction_success_url']);
								}
							}
							elseif(in_array($this->oRecord['transaction_status'], array('OPEN', 'PENDING')))
							{
								if(!empty($this->oRecord['transaction_pending_url']))
								{
									idealcheckout_log('Calling pending URL: ' . $this->oRecord['transaction_pending_url'], __FILE__, __LINE__);
									idealcheckout_doHttpRequest($this->oRecord['transaction_pending_url']);
								}
							}
							elseif(in_array($this->oRecord['transaction_status'], array('CANCELLED')))
							{
								if(!empty($this->oRecord['transaction_failure_url']))
								{
									idealcheckout_log('Calling cancel URL: ' . $this->oRecord['transaction_failure_url'], __FILE__, __LINE__);
									idealcheckout_doHttpRequest($this->oRecord['transaction_failure_url']);
								}
							}
							else // if(strcasecmp($this->oRecord['transaction_status'], 'FAILURE') === 0)
							{
								if(!empty($this->oRecord['transaction_failure_url']))
								{
									idealcheckout_log('Calling failure URL: ' . $this->oRecord['transaction_failure_url'], __FILE__, __LINE__);
									idealcheckout_doHttpRequest($this->oRecord['transaction_failure_url']);
								}
							}
						}
					}
					else
					{
						idealcheckout_log('Status SUCCESS already found, payment already processed.', __FILE__, __LINE__);
					}
				}
				else
				{
					idealcheckout_log('Invalid return request.', __FILE__, __LINE__);
				}
				
				
				$aResponse = array(
					'paymentJobReference' => $aPostData['paymentJobReference'],
					'paymentReference' => $aPostData['paymentReference']);


				http_response_code(200);
				die(json_encode($aResponse));
				
			}

			idealcheckout_output($sHtml);
		}
	}

?>