<?php

	class PayvisionPayment
	{
		private $iBusinessId = false;
		private $sAuthorization = false;
		private $iStoreId = false;
		private $sPaymentMethod = false;
		private $iBrandId = false;
		private $sLanguageCode = false;

		private $sReturnUrl = false;
		private $sReportUrl = false;

		private $sCachePath;

		private $sOrderId = false;
		private $fAmount = false;
		private $sDescription = false;
		private $sCurrencyCode = 'EUR';

		private $bTestMode = false;

		private $aCustomerData = array();
		private $aProductData = array();

		private $aTransaction = false;

		public function __construct($iBusinessId, $sAuthorization, $iStoreId)
		{
			$this->iBusinessId = $iBusinessId;
			$this->sAuthorization = $sAuthorization;
			$this->iStoreId = $iStoreId;
		}

		// Should point to directory where cache is stored (Use FALSE for NO CACHE), make sure directory has read/write privileges
		public function setCachePath($sPath = false)
		{
			$this->sCachePath = $sPath;
		}

		public function setCurrencyCode($sCurrencyCode = false)
		{
			if(is_bool($sCurrencyCode))
			{
				$this->sCurrencyCode = false;
				return true;
			}
			elseif(is_string($sCurrencyCode))
			{
				$sCurrencyCode = strtoupper(substr($sCurrencyCode, 0, 3));

				$this->sCurrencyCode = $sCurrencyCode;
				return true;
			}

			return false;
		}

		public function setLanguageCode($sLanguageCode = false)
		{
			if(is_bool($sLanguageCode))
			{
				$this->sLanguageCode = false;
				return true;
			}
			elseif(is_string($sLanguageCode))
			{
				$sLanguageCode = strtolower(substr($sLanguageCode, 0, 2));

				if(in_array($sLanguageCode, array('nl', 'fr', 'de', 'es', 'en')))
				{
					$this->sLanguageCode = $sLanguageCode;
					return true;
				}
			}

			return false;
		}

		public function setPaymentMethod($sPaymentMethod = false)
		{
			if(is_bool($sPaymentMethod))
			{
				$this->sPaymentMethod = false;
				return true;
			}
			elseif(is_string($sPaymentMethod))
			{
				$sPaymentMethod = strtolower($sPaymentMethod);

				if(strcasecmp($sPaymentMethod, 'ideal') === 0)
				{
					$this->sPaymentMethod = $sPaymentMethod;
					$this->iBrandId = array(3010);
					return true;
				}
			}

			return false;
		}

		public function setOrder($sOrderId, $fAmount, $sDescription = false)
		{
			$this->sOrderId = $sOrderId;
			$this->fAmount = $fAmount;
			$this->sDescription = $sDescription;

			if(empty($this->sDescription))
			{
				$this->sDescription = 'Webshop bestelling ' . $this->sOrderId;
			}

			return true;
		}

		public function setReturnUrl($sReturnUrl = false)
		{
			$this->sReturnUrl = $sReturnUrl;
			return true;
		}

		public function setTestmode($bEnabled = true)
		{
			return ($this->bTestMode = $bEnabled);
		}

		public function getTransaction()
		{
			if(empty($this->iBusinessId))
			{
				idealcheckout_log('No Business ID found.', __FILE__, __LINE__);

				$this->aTransaction = array('error' => array('message' => 'No Business ID found.'));
				return false;
			}
			elseif(empty($this->sAuthorization))
			{
				idealcheckout_log('No Authorization found.', __FILE__, __LINE__);

				$this->aTransaction = array('error' => array('message' => 'No Authorization found.'));
				return false;
			}
			elseif(empty($this->iStoreId))
			{
				idealcheckout_log('No StoreId found.', __FILE__, __LINE__);

				$this->aTransaction = array('error' => array('message' => 'No StoreId found.'));
				return false;
			}
			elseif(empty($this->sOrderId))
			{
				idealcheckout_log('No order ID found.', __FILE__, __LINE__);

				$this->aTransaction = array('error' => array('message' => 'No order ID found.'));
				return false;
			}
			elseif(empty($this->iBrandId))
			{
				idealcheckout_log('No brand ID found.', __FILE__, __LINE__);

				$this->aTransaction = array('error' => array('message' => 'No brand ID found.'));
				return false;
			}
			elseif(empty($this->fAmount))
			{
				idealcheckout_log('No amount found.', __FILE__, __LINE__);

				$this->aTransaction = array('error' => array('message' => 'No amount found.'));
				return false;
			}
			elseif(empty($this->sReturnUrl))
			{
				idealcheckout_log('No return URL found.', __FILE__, __LINE__);

				$this->aTransaction = array('error' => array('message' => 'No return URL found.'));
				return false;
			}


			$aRequest = array();

			// Order data
			$aRequest['header'] = array();
			$aRequest['header']['businessId'] = $this->iBusinessId;

			$aRequest['body'] = array();
			$aRequest['body']['checkout'] = array();
			$aRequest['body']['checkout']['returnUrl'] = $this->sReturnUrl;
			$aRequest['body']['checkout']['brandIds'] = $this->iBrandId;

			$aRequest['body']['transaction'] = array();
			$aRequest['body']['transaction']['authorizationMode'] = 'PAYMENT';
			$aRequest['body']['transaction']['trackingCode'] = $this->sOrderId;
			$aRequest['body']['transaction']['amount'] = $this->fAmount;
			$aRequest['body']['transaction']['currencyCode'] = $this->sCurrencyCode;
			$aRequest['body']['transaction']['languageCode'] = strtoupper($this->sLanguageCode);
			$aRequest['body']['transaction']['purchaseId'] = $this->sOrderId;
			$aRequest['body']['transaction']['source'] = 'EC';
			$aRequest['body']['transaction']['type'] = 'SINGLE';
			$aRequest['body']['transaction']['storeId'] = $this->iStoreId;
			$aRequest['body']['transaction']['descriptor'] = $this->sDescription;

			$sApiUrl = 'https://' . ($this->bTestMode ? 'stag' : '') . 'connect.acehubpaymentservices.com/gateway/v3/checkouts';
			$sPostData = json_encode($aRequest);

			$sResponse = idealcheckout_doHttpRequest($sApiUrl, $sPostData, true, 30, true, array('Authorization: Basic ' . $this->sAuthorization));

			if(!empty($sResponse))
			{
				$this->aTransaction = json_decode($sResponse, true);

				if($this->aTransaction)
				{
					if((isset($this->aTransaction['result']) && ($this->aTransaction['result'] > 0)) && isset($this->aTransaction['body'], $this->aTransaction['body']['checkout'], $this->aTransaction['body']['checkout']['checkoutId'], $this->aTransaction['body']['checkout']['redirect'], $this->aTransaction['body']['checkout']['redirect']['url']))
					{
						return true;
					}
					elseif((isset($this->aTransaction['result']) && ($this->aTransaction['result'] <= 0)) && isset($this->aTransaction['body']['error'], $this->aTransaction['body']['error']['message']))
					{
						$this->aTransaction = array('error' => array('message' => $this->aTransaction['body']['error']['message']));
					}
				}
			}
			else
			{
				$this->aTransaction = array('error' => array('message' => 'No response received from Payvision (See logs).'));
			}

			idealcheckout_log($aRequest, __FILE__, __LINE__);
			idealcheckout_log($sResponse, __FILE__, __LINE__);

			return false;
		}

		public function getTransactionId()
		{
			if(!empty($this->aTransaction['body']['checkout']['checkoutId']))
			{
				return $this->aTransaction['body']['checkout']['checkoutId'];
			}

			return false;
		}

		public function getTransactionUrl()
		{
			if(!empty($this->aTransaction['body']['checkout']['redirect']['url']))
			{
				return $this->aTransaction['body']['checkout']['redirect']['url'];
			}

			return false;
		}

		public function getError()
		{
			if(!empty($this->aTransaction['error']['message']))
			{
				return $this->aTransaction['error']['message'];
			}

			return false;
		}

		public function getStatus($sTransactionId)
		{
			$sApiUrl = 'https://' . ($this->bTestMode ? 'stag' : '') . 'connect.acehubpaymentservices.com/gateway/v3/checkouts/' . $sTransactionId . '?businessId=' . $this->iBusinessId;
			$sResponse = idealcheckout_doHttpRequest($sApiUrl, '', true, 30, true, array('Authorization: Basic ' . $this->sAuthorization));

			if(!empty($sResponse))
			{
				$aResponse = json_decode($sResponse, true);

				if(isset($aResponse['body'], $aResponse['body']['payments'], $aResponse['body']['payments'][0], $aResponse['body']['payments'][0]['result']))
				{
					$iResult = $aResponse['body']['payments'][0]['result'];

					if($iResult === 0)
					{
						return 'SUCCESS';
					}
					elseif($iResult === 2)
					{
						return 'PENDING';
					}
					elseif($iResult === 4)
					{
						return 'EXPIRED';
					}
					elseif($iResult === -4)
					{
						return 'FAILURE';
					}
					elseif($iResult === -10)
					{
						return 'CANCELLED';
					}
				}
			}

			return '';
		}
	}

?>