<?php

	class IDEALCHECKOUT_FOR_JOOMLA_AND_HIKASHOP_2_5_0
	{
		// Return the software name
		public static function getSoftwareName()
		{
			return 'Joomla & Hikashop 2.5.0+';
		}



		// Return the software code
		public static function getSoftwareCode()
		{
			return str_replace('_', '-', substr(basename(__FILE__), 0, -4));
		}



		// Return path to main cinfig file (if any)
		public static function getConfigFile()
		{
			return SOFTWARE_PATH . DS . 'configuration.php';
		}



		// Return path to main cinfig file (if any)
		public static function getConfigData()
		{
			$sConfigFile = self::getConfigFile();

			// Detect DB settings via configuration file
			if(is_file($sConfigFile))
			{
				return file_get_contents($sConfigFile);
			}

			return '';
		}



		// Find default database settings
		public static function getDatabaseSettings($aSettings)
		{
			$aSettings['db_prefix'] = 'jos_';
			$sConfigData = self::getConfigData();

			if(!empty($sConfigData))
			{
				$aSettings['db_host'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/host = \'([^\']+)\';/');
				$aSettings['db_user'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/user = \'([^\']+)\';/');
				$aSettings['db_pass'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/password = \'([^\']+)\';/');
				$aSettings['db_name'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/db = \'([^\']+)\';/');
				$aSettings['db_prefix'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/dbprefix = \'([^\']+)\';/');
				$aSettings['db_type'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/dbtype = \'([^\']+)\';/');
			}

			return $aSettings;
		}



		// See if current software == self::$sSoftwareCode
		public static function isSoftware()
		{
			$aFiles = array();
			$aFiles[] = SOFTWARE_PATH . DS . 'configuration.php';
			$aFiles[] = SOFTWARE_PATH . DS . 'administrator' . DS . 'components' . DS . 'com_hikashop';
			$aFiles[] = SOFTWARE_PATH . DS . 'components' . DS . 'com_hikashop';
			// $aFiles[] = SOFTWARE_PATH . DS . 'joomla.xml';

			foreach($aFiles as $sFile)
			{
				if(!is_file($sFile) && !is_dir($sFile))
				{
					return false;
				}
			}

			return true;
		}




		// Install plugin, return text
		public static function doInstall($aSettings)
		{
			IDEALCHECKOUT_INSTALL::doInstall($aSettings);

			// Detect Joomla 1.5 or 1.7
			$sql_39 = "SELECT `package_id` FROM `" . $aSettings['db_prefix'] . "extensions` LIMIT 1;"; // Joomla 2.5+
			$sql_25 = "SELECT `manifest_cache` FROM `" . $aSettings['db_prefix'] . "extensions` LIMIT 1;"; // Joomla 2.5+
			$sql_17 = "SELECT `extension_id` FROM `" . $aSettings['db_prefix'] . "extensions` LIMIT 1;"; // Joomla 1.7+
			$sql_15 = "SELECT `id` FROM `" . $aSettings['db_prefix'] . "plugins` LIMIT 1;"; // Joomla 1.5+

			if(idealcheckout_database_isRecord($sql_39))// Joomla >= 3.9
			{
				$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "extensions` WHERE (`element` = 'idealcheckoutideal') LIMIT 1;";
				if(!idealcheckout_database_isRecord($sql))
				{
					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - iDEAL', `element` = 'idealcheckoutideal', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Mister Cash', `element` = 'idealcheckoutmistercash', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Direct E-Banking', `element` = 'idealcheckoutdirectebanking', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Creditcard', `element` = 'idealcheckoutcreditcard', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - PayPal', `element` = 'idealcheckoutpaypal', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - PaySafeCard', `element` = 'idealcheckoutpaysafecard', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Authorized Transfer (Eenmalige machtiging)', `element` = 'idealcheckoutauthorizedtransfer', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Maestro', `element` = 'idealcheckoutmaestro', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Manual Transfer (Handmatig overboeken)', `element` = 'idealcheckoutmanualtransfer', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Mastercard', `element` = 'idealcheckoutmastercard', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Visa', `element` = 'idealcheckoutvisa', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - vPay', `element` = 'idealcheckoutvpay', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Klarna Account', `element` = 'idealcheckoutklarnaaccount', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `package_id` = '0', `type` = 'plugin', `name` = 'iDEAL Checkout - Klarna Invoice', `element` = 'idealcheckoutklarnainvoice', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '';";
					idealcheckout_database_execute($sql);
				}

			}
			elseif(idealcheckout_database_isRecord($sql_25)) // Joomla >= 2.5
			{
				IDEALCHECKOUT_INSTALL::addLog('Found Joomla 2.5+', __FILE__, __LINE__);

				$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "extensions` WHERE (`element` = 'idealcheckoutideal') LIMIT 1;";
				if(!idealcheckout_database_isRecord($sql))
				{
					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - iDEAL', `element` = 'idealcheckoutideal', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Mister Cash', `element` = 'idealcheckoutmistercash', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Direct E-Banking', `element` = 'idealcheckoutdirectebanking', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Creditcard', `element` = 'idealcheckoutcreditcard', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - PayPal', `element` = 'idealcheckoutpaypal', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - PaySafeCard', `element` = 'idealcheckoutpaysafecard', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Authorized Transfer (Eenmalige machtiging)', `element` = 'idealcheckoutauthorizedtransfer', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Maestro', `element` = 'idealcheckoutmaestro', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Manual Transfer (Handmatig overboeken)', `element` = 'idealcheckoutmanualtransfer', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Mastercard', `element` = 'idealcheckoutmastercard', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Visa', `element` = 'idealcheckoutvisa', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - vPay', `element` = 'idealcheckoutvpay', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Klarna Account', `element` = 'idealcheckoutklarnaaccount', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Klarna Invoice', `element` = 'idealcheckoutklarnainvoice', `folder` = 'hikashoppayment', `access` = 1, `ordering` = 0, `enabled` = 0, `state` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '', `manifest_cache` = '', `custom_data` = '', `system_data` ='';";
					idealcheckout_database_execute($sql);
				}
			}
			elseif(idealcheckout_database_isRecord($sql_17)) // Joomla >= 1.7
			{
				IDEALCHECKOUT_INSTALL::addLog('Found Joomla 1.7+', __FILE__, __LINE__);

				$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "extensions` WHERE (`element` = 'idealcheckoutideal') LIMIT 1;";
				if(!idealcheckout_database_isRecord($sql))
				{
					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - iDEAL', `element` = 'idealcheckoutideal', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '1', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Creditcard', `element` = 'idealcheckoutcreditcard', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Direct E-Banking', `element` = 'idealcheckoutdirectebanking', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Eenmalige machtiging', `element` = 'idealcheckoutauthorizedtransfer', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Handmatig overboeken', `element` = 'idealcheckoutmanualtransfer', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Maestro', `element` = 'idealcheckoutmaestro', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Mastercard', `element` = 'idealcheckoutmastercard', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - MisterCash', `element` = 'idealcheckoutmistercash', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - PayPal', `element` = 'idealcheckoutpaypal', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - PaySafeCard', `element` = 'idealcheckoutpaysafecard', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Visa', `element` = 'idealcheckoutvisa', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - VPAY', `element` = 'idealcheckoutvpay', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Klarna Account', `element` = 'idealcheckoutklarnaaccount', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "extensions` SET `extension_id` = NULL, `type` = 'plugin', `name` = 'iDEAL Checkout - Klarna Invoice', `element` = 'idealcheckoutklarnainvoice', `folder` = 'hikashoppayment', `access` = '1', `ordering` = '1', `enabled` = '0', `state` = '0', `client_id` = '0', `checked_out` = '0', `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);
				}
			}
			elseif(idealcheckout_database_isRecord($sql_15)) // Joomla >= 1.5
			{
				IDEALCHECKOUT_INSTALL::addLog('Found Joomla 1.5+', __FILE__, __LINE__);

				$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "plugins` WHERE (`element` = 'idealcheckoutideal') LIMIT 1;";
				if(!idealcheckout_database_isRecord($sql))
				{
					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - iDEAL', `element` = 'idealcheckoutideal',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Mister Cash',`element` = 'idealcheckoutmistercash',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Direct E-Banking',`element` = 'idealcheckoutdirectebanking',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Credit Card',`element` = 'idealcheckoutcreditcard',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - PayPal',`element` = 'idealcheckoutpaypal',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - PaySafeCard',`element` = 'idealcheckoutpaysafecard',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Authorized Transfer (Eenmalige machtiging)',`element` = 'idealcheckoutauthorizedtransfer',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Maestro', `element` = 'idealcheckoutmaestro',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Manual Transfer (Handmatig overboeken)',`element` = 'idealcheckoutmanualtransfer',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Master Card',`element` = 'idealcheckoutmastercard',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Visa',`element` = 'idealcheckoutvisa',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - vPay',`element` = 'idealcheckoutvpay',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Klarna Account',`element` = 'idealcheckoutklarnaaccount',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "plugins` SET `id` = NULL, `name` = 'iDEAL Checkout - Klarna Invoice',`element` = 'idealcheckoutklarnainvoice',`folder` = 'hikashoppayment',`access` = 0, `ordering` = 0, `published` = 1, `iscore` = 0, `client_id` = 0, `checked_out` = 0, `checked_out_time` = '0000-00-00 00:00:00', `params` = '';";
					idealcheckout_database_execute($sql);
				}
			}
			else
			{
				IDEALCHECKOUT_INSTALL::output('<p>Cannot detect Joomla Version (1.5+, 1.7+ or 2.5+)</p>');
			}

			$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "hikashop_payment` WHERE (`payment_type` = 'idealcheckoutideal') LIMIT 1;";
			if(!idealcheckout_database_isRecord($sql))
			{
				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'iDEAL', `payment_description` = '<p>Betalen met iDEAL.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutideal', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Creditcard', `payment_description` = '<p>Betalen met Creditcard.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutcreditcard', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Direct E-Banking', `payment_description` = '<p>Betalen met Direct E-Banking.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutdirectebanking', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Eenmalige machtiging', `payment_description` = '<p>Betalen met Eenmalige machtiging.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutauthorizedtransfer', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Handmatig overboeken', `payment_description` = '<p>Betalen met Handmatig overboeken.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutmanualtransfer', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Maestro', `payment_description` = '<p>Betalen met Maestro.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutmaestro', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Mastercard', `payment_description` = '<p>Betalen met Mastercard.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutmastercard', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'MisterCash', `payment_description` = '<p>Betalen met MisterCash.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutmistercash', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'PayPal', `payment_description` = '<p>Betalen met PayPal.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutpaypal', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'PaySafeCard', `payment_description` = '<p>Betalen met PaySafeCard.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutpaysafecard', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Visa', `payment_description` = '<p>Betalen met Visa.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutvisa', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'VPAY', `payment_description` = '<p>Betalen met VPAY.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutvpay', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Klarnaaccount', `payment_description` = '<p>Betalen met Klarna Account.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutklarnaaccount', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);

				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "hikashop_payment` SET `payment_id` = NULL, `payment_name` = 'Klarnainvoice', `payment_description` = '<p>Betalen met Klarna Invoice.</p>', `payment_images` = '', `payment_params` = 'O:8:\"stdClass\":3:{s:14:\"invalid_status\";s:9:\"cancelled\";s:14:\"pending_status\";s:7:\"created\";s:15:\"verified_status\";s:9:\"confirmed\";}', `payment_type` = 'idealcheckoutklarnainvoice', `payment_zone_namekey` = '';";
				idealcheckout_database_execute($sql);
			}
			
			$sql = "SHOW COLUMNS FROM `" . $aSettings['db_prefix'] . "idealcheckout_settings` LIKE `webshop_package`";
			
			if(!$aColumn = idealcheckout_database_getRecord($sql))
			{
				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`id` = NULL, 
`keyname` = 'webshop_package',
`value` = 'hikashop'";
				idealcheckout_database_execute($sql);
				
			}
			else
			{
				$sql = "UPDATE `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`value` = 'hikashop' WHERE (`keyname` = 'webshop_package') LIMIT 1";
				idealcheckout_database_execute($sql);
			}
			
			

			return true;
		}



		// Install plugin, return text
		public static function getInstructions($aSettings)
		{
			$sHtml = '';
			$sHtml .= '<ol>';
			$sHtml .= '<li>Log in op de beheeromgeving van uw webshop.</li>';
			$sHtml .= '<li>Ga in het hoofdmenu naar Componenten / Hikashop / Configuration</li>';
			$sHtml .= '<li>Klik binnen Hikashop op Systeem / Betaalmethoden (Payment Methods)</li>';
			$sHtml .= '<li>Klik rechts bovenin op "Nieuw".</li>';
			$sHtml .= '<li>Kies als betaalmethode de waarde "iDEAL Checkout - iDEAL".</li>';
			$sHtml .= '<li>Geef een naam op voor de betaalmethode (Bijv. iDEAL).</li>';
			$sHtml .= '<li>Zet "publiceren" op "Ja"</li>';
			$sHtml .= '<li>Selecteer optioneel een afbeelding.</li>';
			$sHtml .= '<li>Sla de instellingen op.</li>';
			$sHtml .= '<li>Herhaal stap 4 t/m 9 voor de overige betaalmethoden die u wilt aanbieden in uw webshop.</li>';
			$sHtml .= '</ol>';

			return $sHtml;
		}
	}

?>