<?php
/**
 * @package		HikaShop for Joomla!
 * @version		1.5.0
 * @author		www.ideal-checkout.nl
 * @copyright	(C) 2010 HIKARI SOFTWARE. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');

// error_reporting(-1);
// ini_set('display_errors', 1);

require_once(JPATH_ROOT . '/idealcheckout/includes/library.php');

class plgHikashoppaymentIdealcheckoutafterpay extends hikashopPaymentPlugin
{
	public $accepted_currencies = array('EUR', 'GBP', 'USD');
	public $debugData = array();
	public $multiple = true;
	public $name = 'idealcheckoutafterpay';

	public function onPaymentDisplay(&$order, &$methods, &$usable_methods)
	{
		if(!empty($methods))
		{
			foreach($methods as $k => $method)
			{
				if(strcasecmp($method->payment_type, 'idealcheckoutafterpay') !== 0)
				{
					continue;
				}
				elseif(!$method->enabled)
				{
					continue;
				}

				if(!empty($method->payment_zone_namekey))
				{
					$zoneClass = hikashop_get('class.zone');
					$zones = $zoneClass->getOrderZones($order);

					if(!in_array($method->payment_zone_namekey, $zones))
					{
						return true;
					}
				}

				$currencyClass = hikashop_get('class.currency');
				$null = null;
				$currency_id = intval(@$order->total->prices[0]->price_currency_id);
				$currency = $currencyClass->getCurrencies($currency_id, $null);

				if(!empty($currency))
				{
					if(!in_array(@$currency[$currency_id]->currency_code, $this->accepted_currencies))
					{
						return true;
					}
				}

				$usable_methods[$method->ordering] = $method;
			}
		}

		return true;
	}

	public function onAfterOrderConfirm(&$order, &$methods, $method_id)
	{
		parent::onAfterOrderConfirm($order, $methods, $method_id);

		if(empty($this->payment_params))
		{
			return false;
		}

		$oLanguage = JFactory::getLanguage();
		$sLanguageCode = strtolower(substr($oLanguage->get('tag'), 0, 2));

		if(!in_array($sLanguageCode, array('nl', 'en', 'de')))
		{
			$sLanguageCode = 'nl';
		}

		// Create transaction record
		$aDatabaseSettings = idealcheckout_getDatabaseSettings();

		$sStoreCode = idealcheckout_getStoreCode();
		$sGatewayCode = 'afterpay';
		// $sLanguageCode = 'nl'; // nl, de, en
		$sCountryCode = '';
		$sCurrencyCode = 'EUR';

		
		
		$oShipmentAddress = ((isset($order->cart->shipping_address)) ? $order->cart->shipping_address : $order->cart->billing_address);
		$oBillingAddress = ((isset($order->cart->billing_address)) ? $order->cart->billing_address : $order->cart->shipping_address);

		
		$aOrderParams['customer'] = array();

		// Shipment data
		list($sStreetName, $sStreetNumber, $sExtension) = idealcheckout_mb_splitAddress($oShipmentAddress->address_street . ' ' . $oShipmentAddress->address_street2);

		
		$sCountryCode = $oShipmentAddress->address_country->zone_code_2;
		$sCountryName = $oShipmentAddress->address_country->zone_name;

		$aOrderParams['customer']['shipment_company'] = '';
		$aOrderParams['customer']['shipment_name'] = $oShipmentAddress->address_firstname . ' ' . $oShipmentAddress->address_lastname;
		$aOrderParams['customer']['shipment_first_name'] = $oShipmentAddress->address_firstname;
		$aOrderParams['customer']['shipment_last_name'] = $oShipmentAddress->address_lastname;
		$aOrderParams['customer']['shipment_gender'] = '';
		$aOrderParams['customer']['shipment_date_of_birth'] = '';
		$aOrderParams['customer']['shipment_phone'] = $oShipmentAddress->address_telephone;
		$aOrderParams['customer']['shipment_email'] = $this->user->user_email;
		$aOrderParams['customer']['shipment_address'] = $oShipmentAddress->address_street . (empty($oShipmentAddress->address_street2) ? '' : ', ' . $oShipmentAddress->address_street2);
		$aOrderParams['customer']['shipment_street_name'] = $sStreetName;
		$aOrderParams['customer']['shipment_street_number'] = $sStreetNumber;
		$aOrderParams['customer']['shipment_street_number_extension'] = $sExtension;
		$aOrderParams['customer']['shipment_zipcode'] = $oShipmentAddress->address_post_code;
		$aOrderParams['customer']['shipment_city'] = $oShipmentAddress->address_city;
		$aOrderParams['customer']['shipment_country_code'] = $sCountryCode;
		$aOrderParams['customer']['shipment_country_name'] = $sCountryName;


		// Payment data
		list($sStreetName, $sStreetNumber, $sExtension) = idealcheckout_mb_splitAddress($oBillingAddress->address_1 . ' ' . $oBillingAddress->address_2);

		$sCountryCode = $oBillingAddress->address_country->zone_code_2;
		$sCountryName = $oBillingAddress->address_country->zone_name;
		

		$aOrderParams['customer']['payment_company'] = '';
		$aOrderParams['customer']['payment_name'] = $oBillingAddress->address_firstname . ' ' . $oBillingAddress->address_lastname;
		$aOrderParams['customer']['payment_first_name'] = $oBillingAddress->address_firstname;
		$aOrderParams['customer']['payment_last_name'] = $oBillingAddress->address_lastname;
		$aOrderParams['customer']['payment_gender'] = '';
		$aOrderParams['customer']['payment_date_of_birth'] = '';
		$aOrderParams['customer']['payment_phone'] = $oBillingAddress->address_telephone;
		$aOrderParams['customer']['payment_email'] = $this->user->user_email;
		$aOrderParams['customer']['payment_address'] = $oBillingAddress->address_street . (empty($oBillingAddress->address_street2) ? '' : ', ' . $oBillingAddress->address_street2);
		$aOrderParams['customer']['payment_street_name'] = $sStreetName;
		$aOrderParams['customer']['payment_street_number'] = $sStreetNumber;
		$aOrderParams['customer']['payment_street_number_extension'] = $sExtension;
		$aOrderParams['customer']['payment_zipcode'] = $oBillingAddress->address_post_code;
		$aOrderParams['customer']['payment_city'] = $oBillingAddress->address_city;
		$aOrderParams['customer']['payment_country_code'] = $sCountryCode;
		$aOrderParams['customer']['payment_country_name'] = $sCountryName;

	
	
		// Product data
		foreach($order->cart->products as $oProduct) 
		{			
		
			$sDescription = substr(strip_tags($oProduct->order_product_name), 0, 127);
			$sProductId = $oProduct->order_product_code;
			$iProductQuantity = $oProduct->order_product_quantity;
						
			$fPriceExcl = round($oProduct->order_product_total_price_no_vat, 2);
			$fPriceVat = round($oProduct->order_product_tax, 2);
			
			if(($fPriceExcl < 0) || ($fPriceExcl > 0))
			{
			
				$fVatPercentage = round(($fPriceVat / $fPriceExcl) * 100, 0);
				$sVatPercentage = (($fVatPercentage < 10) ? '0' : '') . number_format($fVatPercentage * 1000, 0, '', '');
				$fPriceIncl = round($fPriceExcl + $fPriceVat, 2);
			
				$aOrderParams['products'][] = array(
'record_id' => $oProduct->product_id, 
'code' => $sProductId, 
'description' => $sDescription, 
'quantity' => $iProductQuantity, 
'price_incl' => $fPriceIncl, 
'price_excl' => $fPriceExcl, 
'vat' => $fVatPercentage, 
'vat_amount' => $fPriceVat);

			}
		}
		
	
			
		// Shipping cost
		if(!empty($order->order_shipping_price) && bccomp($order->order_shipping_price, 0, 5)) 
		{			
			$fShipmentAmount = number_format($order->order_shipping_price - @$order->order_shipping_tax, 2, '.', '');
			$fShipmentTaxAmount = round($order->order_shipping_tax, (int)$this->currency->currency_locale['int_frac_digits']);

			if(($fShipmentAmount < 0) || ($fShipmentAmount > 0))
			{
				$fShipmentTaxPercentage = round(($fShipmentTaxAmount / $fShipmentAmount) * 100, 0);
				$aOrderParams['products'][] = array('record_id' => 0, 'code' => 'SHIPPING', 'description' => 'Verzendkosten', 'quantity' => '1', 'price_incl' => ($fShipmentAmount + $fShipmentTaxAmount), 'price_excl' => $fShipmentAmount, 'vat' => $fShipmentTaxPercentage, 'vat_amount' => $fShipmentTaxAmount);
			}
		}

		// Payment cost
		if(!empty($order->order_payment_price) && bccomp($order->order_payment_price, 0, 5)) 
		{
			$fPaymentAmount = number_format($order->order_payment_price - @$order->order_payment_tax, (int)$this->currency->currency_locale['int_frac_digits']);
			$fPaymentTaxAmount = round($order->order_payment_tax, (int)$this->currency->currency_locale['int_frac_digits']);

			if(($fPaymentAmount < 0) || ($fPaymentAmount > 0))
			{
				$fPaymentTaxPercentage = round(($fPaymentTaxAmount / $fPaymentAmount) * 100, 0);
				$aOrderParams['products'][] = array('record_id' => 0, 'code' => 'PAYMENT', 'description' => 'Betaalkosten', 'quantity' => '1', 'price_incl' => ($fPaymentAmount + $fPaymentTaxAmount), 'price_excl' => $fPaymentAmount, 'vat' => $fPaymentTaxPercentage, 'vat_amount' => $fPaymentTaxAmount);
			}
		}
	
		
		
		$sOrderId = $order->order_id;
		$sOrderCode = idealcheckout_getRandomCode(32);
		
		$sTransactionId = idealcheckout_getRandomCode(32);
		$sTransactionCode = idealcheckout_getRandomCode(32);
		$fTransactionAmount = round($order->order_full_price, 2);
		$sTransactionDescription = idealcheckout_getTranslation($sLanguageCode, 'idealcheckout', 'Webshop order #{0}', array($sOrderId));
		$sTransactionPaymentUrl = ''; // HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id=' . $sOrderId;
		$sTransactionSuccessUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutafterpay&tmpl=component&lang=' . $sLanguageCode;
		$sTransactionPendingUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutafterpay&tmpl=component&lang=' . $sLanguageCode;
		$sTransactionFailureUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutafterpay&tmpl=component&lang=' . $sLanguageCode;
		$aTransactionParams = array();

		$sql = "INSERT INTO `" . $aDatabaseSettings['table'] . "` SET 
`id` = NULL, 
`order_id` = '" . idealcheckout_escapeSql($sOrderId) . "', 
`order_code` = '" . idealcheckout_escapeSql($sOrderCode) . "', 
`order_params` = '" . idealcheckout_escapeSql(idealcheckout_serialize($aOrderParams)) . "', 
`store_code` = " . (empty($sStoreCode) ? "NULL" : "'" . idealcheckout_escapeSql($sStoreCode) . "'") . ", 
`gateway_code` = '" . idealcheckout_escapeSql($sGatewayCode) . "', 
`language_code` = " . (empty($sLanguageCode) ? "NULL" : "'" . idealcheckout_escapeSql($sLanguageCode) . "'") . ", 
`country_code` = " . (empty($sCountryCode) ? "NULL" : "'" . idealcheckout_escapeSql($sCountryCode) . "'") . ", 
`currency_code` = '" . idealcheckout_escapeSql($sCurrencyCode) . "', 
`transaction_id` = '" . idealcheckout_escapeSql($sTransactionId) . "', 
`transaction_code` = '" . idealcheckout_escapeSql($sTransactionCode) . "', 
`transaction_params` = NULL, 
`transaction_date` = '" . idealcheckout_escapeSql(time()) . "', 
`transaction_amount` = '" . idealcheckout_escapeSql($fTransactionAmount) . "', 
`transaction_description` = '" . idealcheckout_escapeSql($sTransactionDescription) . "', 
`transaction_status` = NULL, 
`transaction_url` = NULL, 
`transaction_payment_url` = '" . idealcheckout_escapeSql($sTransactionPaymentUrl) . "', 
`transaction_success_url` = '" . idealcheckout_escapeSql($sTransactionSuccessUrl) . "', 
`transaction_pending_url` = '" . idealcheckout_escapeSql($sTransactionPendingUrl) . "', 
`transaction_failure_url` = '" . idealcheckout_escapeSql($sTransactionFailureUrl) . "', 
`transaction_log` = NULL;";
		idealcheckout_database_query($sql);

		// Set URL to /idealcheckout/setup.php
		define('IDEAL_SETUP_URL', HIKASHOP_LIVE . 'idealcheckout/setup.php?order_id=' . $sOrderId . '&order_code=' . $sOrderCode);

		return $this->showPage('end');
	}


	public function onPaymentNotification(&$aStatuses)
	{
		$oConfig =& hikashop_config();
		$bSendEmails = false;

		if($oConfig->get('payment_notification_email'))
		{
			$bSendEmails = true;
		}
		else
		{
			idealcheckout_log('No e-mail was set for payment notifications.', __FILE__, __LINE__);
		}

		if(empty($_GET['order_id']) || empty($_GET['order_code']))
		{
			if($this->payment_params->debug)
			{
				echo "<br>\n" . 'DEBUG: ' . __FILE__ . ' : ' . __LINE__ . "<br>\n";
				print_r($_GET);
			}

			return false;
		}


		$sOrderId = intval($_GET['order_id']);
		$sOrderCode = $_GET['order_code'];


		// Get transaction record
		$aDatabaseSettings = idealcheckout_getDatabaseSettings();
		$sql = "SELECT `transaction_id` AS `id`, `transaction_status` AS `status`, `transaction_amount` AS `amount`, `transaction_params` AS `params` FROM `" . $aDatabaseSettings['table'] . "` WHERE (`order_id` = '" . idealcheckout_escapeSql($sOrderId) . "') AND (`order_code` = '" . idealcheckout_escapeSql($sOrderCode) . "') LIMIT 1;";

		$aTransaction = idealcheckout_database_getRecord($sql);

		if($aTransaction === false)
		{
			if($this->payment_params->debug)
			{
				echo "<br>\n" . 'DEBUG: ' . __FILE__ . ' : ' . __LINE__ . "<br>\n";
				print_r($_GET);

				echo "<br>\n" . 'DEBUG: ' . __FILE__ . ' : ' . __LINE__ . "<br>\n";
				print_r($sql);
			}

			return false;
		}


		// Get Hikashop Order
		$oOrder = $this->getOrder($sOrderId);

		if(empty($oOrder))
		{
			echo "Could not load any order for your notification " . $sOrderId;
			return false;
		}

		$this->loadPaymentParams($oOrder);

		if(empty($this->payment_params))
		{
			echo "Could not load any payment params for your notification " . $sOrderId;
			return false;
		}

		$this->loadOrderData($oOrder);

		$sOrderUrl = HIKASHOP_LIVE . 'administrator/index.php?option=com_hikashop&ctrl=order&task=edit&order_id=' . $sOrderId;
		$sOrderText = "\r\n" . JText::sprintf('NOTIFICATION_OF_ORDER_ON_WEBSITE', $oOrder->order_number, HIKASHOP_LIVE);
		$sOrderText .= "\r\n" . str_replace('<br/>', "\r\n", JText::sprintf('ACCESS_ORDER_WITH_LINK', $sOrderUrl));

		if(in_array($aTransaction['status'], array('SUCCESS')))
		{
			// if(strcasecmp($oOrder->order_status, $this->payment_params->verified_status) !== 0)
			{
				$sOrderStatus = $this->payment_params->verified_status;
				$sMailStatus = $aStatuses[$this->payment_params->verified_status];

				$oHistory = new stdClass();
				$oHistory->reason = JText::_('PAYMENT_ORDER_CONFIRMED');
				$oHistory->notified = 1;
				$oHistory->data = 'AfterPay payment SUCCESS - Order ID: ' . $sOrderId . ' - Transaction ID: ' . $aTransaction['id'];

				$oEmail = null;

				if($bSendEmails)
				{
					$oEmail = new stdClass();
					$oEmail->subject = 'AfterPay payment SUCCESS - Order ID: ' . $sOrderId . ' - Transaction ID: ' . $aTransaction['id'];
					$oEmail->body = str_replace('<br/>', "\r\n", JText::sprintf('PAYMENT_NOTIFICATION_STATUS', 'AfterPay', $sOrderStatus)) . ' ' . JText::sprintf('ORDER_STATUS_CHANGED', $sMailStatus) . "\r\n\r\n" . $sOrderText;
				}

				$this->modifyOrder($sOrderId, $sOrderStatus, $oHistory, $oEmail);
			}

			header('Location: ' . HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id=' . $sOrderId);
			echo '<form method="post" action="' . htmlspecialchars(HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id=' . $sOrderId) . '" name="idealcheckout_form" id="idealcheckout_form"><script type="text/javascript"> function idealcheckout_redirect() { document.idealcheckout_form.submit(); } setTimeout(\'idealcheckout_redirect()\', 1000); </script></form>';

			return true;
		}
		elseif(in_array($aTransaction['status'], array('PENDING', 'OPEN')))
		{
			if(strcasecmp($oOrder->order_status, $this->payment_params->pending_status) !== 0) // Already pending/open
			{
				$sOrderStatus = $this->payment_params->pending_status;

				$oHistory = new stdClass();
				$oHistory->reason = JText::_('PAYMENT_ORDER_PENDING');
				$oHistory->notified = 1;
				$oHistory->data = 'AfterPay payment PENDING - Order ID: ' . $sOrderId;

				$this->modifyOrder($sOrderId, $sOrderStatus, $oHistory);
			}

			return true;
		}
		else // if(in_array($aTransaction['status'], array('CANCELLED', 'EXPIRED', 'FAILURE')))
		{
			if(strcasecmp($oOrder->order_status, $this->payment_params->invalid_status) !== 0)
			{
				$sOrderStatus = $this->payment_params->invalid_status;
				$sMailStatus = $aStatuses[$this->payment_params->invalid_status];

				$oHistory = new stdClass();
				$oHistory->reason = JText::_('PAYMENT_ORDER_CANCELLED');
				$oHistory->notified = 1;
				$oHistory->data = 'AfterPay payment CANCELLED - Order ID: ' . $sOrderId;

				$oEmail = null;

				if($bSendEmails)
				{
					$oEmail = new stdClass();
					$oEmail->subject = 'AfterPay payment CANCELLED - Order ID: ' . $sOrderId;
					$oEmail->body = str_replace('<br/>', "\r\n", JText::sprintf('PAYMENT_NOTIFICATION_STATUS', 'AfterPay', $sOrderStatus)) . ' ' . JText::sprintf('ORDER_STATUS_CHANGED', $sMailStatus) . "\r\n\r\n" . $sOrderText;
				}

				$this->modifyOrder($sOrderId, $sOrderStatus, $oHistory, $oEmail);
			}

			header('Location: ' . HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id=' . $sOrderId);
			echo '<form method="post" action="' . htmlspecialchars(HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id=' . $sOrderId) . '" name="idealcheckout_form" id="idealcheckout_form"><script type="text/javascript"> function idealcheckout_redirect() { document.idealcheckout_form.submit(); } setTimeout(\'idealcheckout_redirect()\', 1000); </script></form>';

			return false;
		}
	}

	public function onPaymentConfigurationSave(&$element)
	{
		if(empty($element->payment_params->currency))
		{
			$element->payment_params->currency = $this->accepted_currencies[0];
		}

		return true;
	}

	public function getPaymentDefaultValues(&$element)
	{
		$element->payment_name = 'AfterPay';
		$element->payment_description = 'Betalen met AfterPay';
		$element->payment_images = '';

		$element->payment_params->notification = 1;
		$element->payment_params->currency = $this->accepted_currencies[0];

		$element->payment_params->invalid_status = 'cancelled';
		$element->payment_params->pending_status = 'created';
		$element->payment_params->verified_status = 'confirmed';
	}
}