<?php
/**
 * @package	HikaShop for Joomla!
 * @version	2.2.3
 * @author	hikashop.com
 * @copyright	(C) 2010-2013 HIKARI SOFTWARE. All rights reserved.
 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');

class plgHikashoppaymentIdealcheckoutbancontact extends hikashopPaymentPlugin
{
	public $accepted_currencies = array('EUR', 'GBP', 'USD');
	public $debugData = array();

	function onAfterOrderConfirm(&$order, &$methods, $method_id)
	{
		parent::onAfterOrderConfirm($order, $methods, $method_id);

		if(empty($this->payment_params))
		{
			return false;
		}

		$this->vars = $this->getVars($order);

		return $this->showPage('end');
	


		$method = &$methods[$method_id];
		$tax_total = '';
		$discount_total = '';
		$currencyClass = hikashop::get('class.currency');
		$currencies = null;
		$currencies = $currencyClass->getCurrencies($order->order_currency_id,$currencies);
		$currency = $currencies[$order->order_currency_id];
		$user = hikashop::loadUser(true);
		$lang = &JFactory::getLanguage();
		$locale = strtolower(substr($lang->get('tag'),0,2));



		// Calculate total price
		$vars = array();
		$i = 1;
		$tax = 0;
		$total = 0;

		$aProductsInCart = array();

		foreach($order->cart->products as $product)
		{
			$vars["item_name_".$i]=substr($product->order_product_name,0,127);
			$vars["item_number_".$i]=$product->order_product_code;
			$vars["amount_".$i]=round($product->order_product_price,(int)$currency->currency_locale['int_frac_digits']);
			$vars["quantity_".$i]=$product->order_product_quantity;

			$aProductsInCart[$product->product_id] = $product->order_product_quantity;

			$tax+=round($product->order_product_tax,(int)$currency->currency_locale['int_frac_digits'])*$product->order_product_quantity;
			$total += round($product->order_product_price,(int)$currency->currency_locale['int_frac_digits'])*$product->order_product_quantity;

			$i++;
		}

		if(bccomp($tax,0,5)){
			$vars['tax_cart']=$tax;
			$total += round($tax,(int)$currency->currency_locale['int_frac_digits']);
		}

		if(!empty($order->order_shipping_price)){
			$vars["item_name_".$i]=JText::_('HIKASHOP_SHIPPING');
			$vars["amount_".$i]=round($order->order_shipping_price,(int)$currency->currency_locale['int_frac_digits']);
			$vars["quantity_".$i]=1;

			$total += round($order->order_shipping_price,(int)$currency->currency_locale['int_frac_digits']);
			$i++;
		}

		if(!empty($order->cart->coupon)){
			$vars["discount_amount_cart"]=round($order->cart->coupon->discount_value,(int)$currency->currency_locale['int_frac_digits']);
			$total -= round($order->cart->coupon->discount_value,(int)$currency->currency_locale['int_frac_digits']);
		}


		// Load gateway settings
		require_once(JPATH_ROOT . '/idealcheckout/includes/library.php');


		// Create transaction record
		$aDatabaseSettings = idealcheckout_getDatabaseSettings();

		$sStoreCode = idealcheckout_getStoreCode();
		$sGatewayCode = 'bancontact';
		$sLanguageCode = 'nl'; // nl, de, en
		$sCountryCode = '';
		$sCurrencyCode = 'EUR';

		$sOrderId = $order->order_id;
		$sOrderCode = idealcheckout_getRandomCode(32);
		$aOrderParams = array('cart' => $aProductsInCart);
		$sTransactionId = idealcheckout_getRandomCode(32);
		$sTransactionCode = idealcheckout_getRandomCode(32);
		$fTransactionAmount = round($total, 2);
		$sTransactionDescription = idealcheckout_getTranslation($sLanguageCode, 'idealcheckout', 'Webshop order #{0}', array($sOrderId));
		$sTransactionPaymentUrl = ''; // HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id=' . $sOrderId;
		$sTransactionSuccessUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutbancontact&tmpl=component&lang=' . $locale;
		$sTransactionPendingUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutbancontact&tmpl=component&lang=' . $locale;
		$sTransactionFailureUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutbancontact&tmpl=component&lang=' . $locale;
		$aTransactionParams = array();


		$sql = "INSERT INTO `" . $aDatabaseSettings['table'] . "` SET 
`id` = NULL, 
`order_id` = '" . idealcheckout_escapeSql($sOrderId) . "', 
`order_code` = '" . idealcheckout_escapeSql($sOrderCode) . "', 
`order_params` = '" . idealcheckout_escapeSql(idealcheckout_serialize($aOrderParams)) . "', 
`store_code` = " . (empty($sStoreCode) ? "NULL" : "'" . idealcheckout_escapeSql($sStoreCode) . "'") . ", 
`gateway_code` = '" . idealcheckout_escapeSql($sGatewayCode) . "', 
`language_code` = " . (empty($sLanguageCode) ? "NULL" : "'" . idealcheckout_escapeSql($sLanguageCode) . "'") . ", 
`country_code` = " . (empty($sCountryCode) ? "NULL" : "'" . idealcheckout_escapeSql($sCountryCode) . "'") . ", 
`currency_code` = '" . idealcheckout_escapeSql($sCurrencyCode) . "', 
`transaction_id` = '" . idealcheckout_escapeSql($sTransactionId) . "', 
`transaction_code` = '" . idealcheckout_escapeSql($sTransactionCode) . "', 
`transaction_params` = NULL, 
`transaction_date` = '" . idealcheckout_escapeSql(time()) . "', 
`transaction_amount` = '" . idealcheckout_escapeSql($fTransactionAmount) . "', 
`transaction_description` = '" . idealcheckout_escapeSql($sTransactionDescription) . "', 
`transaction_status` = NULL, 
`transaction_url` = NULL, 
`transaction_payment_url` = '" . idealcheckout_escapeSql($sTransactionPaymentUrl) . "', 
`transaction_success_url` = '" . idealcheckout_escapeSql($sTransactionSuccessUrl) . "', 
`transaction_pending_url` = '" . idealcheckout_escapeSql($sTransactionPendingUrl) . "', 
`transaction_failure_url` = '" . idealcheckout_escapeSql($sTransactionFailureUrl) . "', 
`transaction_log` = NULL;";

		$db = & JFactory::getDBO();
		$db->setQuery($sql);
		$db->query();

		// Set URL to /idealcheckout/setup.php
		define('IDEAL_SETUP_URL', HIKASHOP_LIVE . 'idealcheckout/setup.php?order_id=' . $sOrderId . '&order_code=' . $sOrderCode);

		if(HIKASHOP_J3) 
		{
			JHTML::_('behavior.framework');
		}
		else
		{
			JHTML::_('behavior.mootools');
		}

		$app =& JFactory::getApplication();
		$name = $method->payment_type.'_end.php';
    	$path = JPATH_THEMES.DS.$app->getTemplate().DS.'hikashoppayment'.DS.$name;
    	if(!file_exists($path)){
    		if(version_compare(JVERSION,'1.6','<')){
    			$path = JPATH_PLUGINS .DS.'hikashoppayment'.DS.$name;
    		}else{
    			$path = JPATH_PLUGINS .DS.'hikashoppayment'.DS.$method->payment_type.DS.$name;
    		}

			if(!file_exists($path)){
    			return true;
    		}
    	}

		require($path);
    	return true;
    }
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	}

	function onPaymentNotification(&$statuses){
		$order_id = (int)@$_GET['orderid'];

		$dbOrder = $this->getOrder($order_id);
		if(empty($dbOrder)){
			echo "Could not load any order for your notification ".@$_GET['orderid'];
			return false;
		}

		$this->loadPaymentParams($dbOrder);
		if(empty($this->payment_params))
			return false;
		$this->loadOrderData($dbOrder);
		if($this->payment_params->debug){
			echo print_r($dbOrder,true)."\n\n\n";
		}

		$order_status = $dbOrder->order_status;

		$url = HIKASHOP_LIVE.'administrator/index.php?option=com_hikashop&ctrl=order&task=edit&order_id='.$order_id;
		$order_text = "\r\n".JText::sprintf('NOTIFICATION_OF_ORDER_ON_WEBSITE',$dbOrder->order_number,HIKASHOP_LIVE);
		$order_text .= "\r\n".str_replace('<br/>',"\r\n",JText::sprintf('ACCESS_ORDER_WITH_LINK',$url));

		if($this->payment_params->debug){
			echo print_r($dbOrder,true)."\n\n\n";
		}

		if($this->payment_params->debug){
			echo print_r($_GET,true)."\n\n\n";
		}

		if(strlen($this->payment_params->md5key) > 0)
		{
			$var = "";
			$params = $_GET;


			foreach($params as $key => $value)
			{
				if($key != "hash")
				{
					$var .= $value;
				}
				else
					break;
			}

			$genstamp = md5($var . $this->payment_params->md5key);

			if($genstamp != $_GET["hash"])
			{
				$history = new stdClass();
				$email = new stdClass();
				$history->notified = 0;
				$history->reason = JText::_('PAYMENT_MD5_ERROR');
				$history->data = "Payment by ePay - Invalid MD5 - ePay transaction ID: " . $_GET["tid"];
				$email->subject = JText::sprintf('NOTIFICATION_REFUSED_FOR_THE_ORDER','ePay').'invalid response';
				$email->body = JText::sprintf("Hello,\r\n An ePay notification was refused because the notification from the ePay server was invalid")."\r\n\r\n".$order_text;
				$order_status = $this->payment_params->invalid_status;

				$this->modifyOrder($order_id,$order_status,$history,$email);

				return false;
			}
		}

		$order_status = $this->payment_params->verified_status;
		if($dbOrder->order_status == $order_status) return true;

		$history->reason = JText::_('PAYMENT_ORDER_CONFIRMED');
		$history->notified=1;
		$history->data = "Payment by ePay - ePay transaction ID: ".$_GET["tid"];

		$mail_status = $statuses[$order_status];
		$email->subject = JText::sprintf('PAYMENT_NOTIFICATION_FOR_ORDER','ePay',$order_status,$dbOrder->order_number); //order_id ?
		$email->body = str_replace('<br/>',"\r\n",JText::sprintf('PAYMENT_NOTIFICATION_STATUS','ePay',$order_status)).' '.JText::sprintf('ORDER_STATUS_CHANGED',$mail_status)."\r\n\r\n".$order_text; //order->mail_status == order_status ?

		$this->modifyOrder($order_id,$order_status,$history,$email);
		return true;
	}

	function getPaymentDefaultValues(&$element) {
		$element->payment_name='ePay';
		$element->payment_description='You can pay by credit card or epay using this payment method';
		$element->payment_images='MasterCard,VISA,Credit_card,American_Express';
		$element->payment_params->notification=1;
		$element->payment_params->windowstate=1;
		$element->payment_params->windowid=1;
		$element->payment_params->instantcapture=0;
		$element->payment_params->ownreceipt=0;
		$element->payment_params->invalid_status='cancelled';
		$element->payment_params->pending_status='created';
		$element->payment_params->verified_status='confirmed';
	}

	function get_iso_code($code) {
		switch (strtoupper($code)){
			case 'ADP': return '020';
			case 'AED': return '784';
			case 'AFA': return '004';
			case 'ALL': return '008';
			case 'AMD': return '051';
			case 'ANG': return '532';
			case 'AOA': return '973';
			case 'ARS': return '032';
			case 'AUD': return '036';
			case 'AWG': return '533';
			case 'AZM': return '031';
			case 'BAM': return '977';
			case 'BBD': return '052';
			case 'BDT': return '050';
			case 'BGL': return '100';
			case 'BGN': return '975';
			case 'BHD': return '048';
			case 'BIF': return '108';
			case 'BMD': return '060';
			case 'BND': return '096';
			case 'BOB': return '068';
			case 'BOV': return '984';
			case 'BRL': return '986';
			case 'BSD': return '044';
			case 'BTN': return '064';
			case 'BWP': return '072';
			case 'BYR': return '974';
			case 'BZD': return '084';
			case 'CAD': return '124';
			case 'CDF': return '976';
			case 'CHF': return '756';
			case 'CLF': return '990';
			case 'CLP': return '152';
			case 'CNY': return '156';
			case 'COP': return '170';
			case 'CRC': return '188';
			case 'CUP': return '192';
			case 'CVE': return '132';
			case 'CYP': return '196';
			case 'CZK': return '203';
			case 'DJF': return '262';
			case 'DKK': return '208';
			case 'DOP': return '214';
			case 'DZD': return '012';
			case 'ECS': return '218';
			case 'ECV': return '983';
			case 'EEK': return '233';
			case 'EGP': return '818';
			case 'ERN': return '232';
			case 'ETB': return '230';
			case 'EUR': return '978';
			case 'FJD': return '242';
			case 'FKP': return '238';
			case 'GBP': return '826';
			case 'GEL': return '981';
			case 'GHC': return '288';
			case 'GIP': return '292';
			case 'GMD': return '270';
			case 'GNF': return '324';
			case 'GTQ': return '320';
			case 'GWP': return '624';
			case 'GYD': return '328';
			case 'HKD': return '344';
			case 'HNL': return '340';
			case 'HRK': return '191';
			case 'HTG': return '332';
			case 'HUF': return '348';
			case 'IDR': return '360';
			case 'ILS': return '376';
			case 'INR': return '356';
			case 'IQD': return '368';
			case 'IRR': return '364';
			case 'ISK': return '352';
			case 'JMD': return '388';
			case 'JOD': return '400';
			case 'JPY': return '392';
			case 'KES': return '404';
			case 'KGS': return '417';
			case 'KHR': return '116';
			case 'KMF': return '174';
			case 'KPW': return '408';
			case 'KRW': return '410';
			case 'KWD': return '414';
			case 'KYD': return '136';
			case 'KZT': return '398';
			case 'LAK': return '418';
			case 'LBP': return '422';
			case 'LKR': return '144';
			case 'LRD': return '430';
			case 'LSL': return '426';
			case 'LTL': return '440';
			case 'LVL': return '428';
			case 'LYD': return '434';
			case 'MAD': return '504';
			case 'MDL': return '498';
			case 'MGF': return '450';
			case 'MKD': return '807';
			case 'MMK': return '104';
			case 'MNT': return '496';
			case 'MOP': return '446';
			case 'MRO': return '478';
			case 'MTL': return '470';
			case 'MUR': return '480';
			case 'MVR': return '462';
			case 'MWK': return '454';
			case 'MXN': return '484';
			case 'MXV': return '979';
			case 'MYR': return '458';
			case 'MZM': return '508';
			case 'NAD': return '516';
			case 'NGN': return '566';
			case 'NIO': return '558';
			case 'NOK': return '578';
			case 'NPR': return '524';
			case 'NZD': return '554';
			case 'OMR': return '512';
			case 'PAB': return '590';
			case 'PEN': return '604';
			case 'PGK': return '598';
			case 'PHP': return '608';
			case 'PKR': return '586';
			case 'PLN': return '985';
			case 'PYG': return '600';
			case 'QAR': return '634';
			case 'ROL': return '642';
			case 'RUB': return '643';
			case 'RUR': return '810';
			case 'RWF': return '646';
			case 'SAR': return '682';
			case 'SBD': return '090';
			case 'SCR': return '690';
			case 'SDD': return '736';
			case 'SEK': return '752';
			case 'SGD': return '702';
			case 'SHP': return '654';
			case 'SIT': return '705';
			case 'SKK': return '703';
			case 'SLL': return '694';
			case 'SOS': return '706';
			case 'SRG': return '740';
			case 'STD': return '678';
			case 'SVC': return '222';
			case 'SYP': return '760';
			case 'SZL': return '748';
			case 'THB': return '764';
			case 'TJS': return '972';
			case 'TMM': return '795';
			case 'TND': return '788';
			case 'TOP': return '776';
			case 'TPE': return '626';
			case 'TRL': return '792';
			case 'TRY': return '949';
			case 'TTD': return '780';
			case 'TWD': return '901';
			case 'TZS': return '834';
			case 'UAH': return '980';
			case 'UGX': return '800';
			case 'USD': return '840';
			case 'UYU': return '858';
			case 'UZS': return '860';
			case 'VEB': return '862';
			case 'VND': return '704';
			case 'VUV': return '548';
			case 'XAF': return '950';
			case 'XCD': return '951';
			case 'XOF': return '952';
			case 'XPF': return '953';
			case 'YER': return '886';
			case 'YUM': return '891';
			case 'ZAR': return '710';
			case 'ZMK': return '894';
			case 'ZWD': return '716';
		}
		return '208';
	}
}
