<?php
/**
 * @package		HikaShop for Joomla!
 * @version		1.5.0
 * @author		www.ideal-checkout.nl
 * @copyright	(C) 2010 HIKARI SOFTWARE. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?>
<?php
class plgHikashoppaymentIdealcheckoutbancontact extends JPlugin
{
	var $accepted_currencies = array(
		'EUR'
	);
    var $debugData = array();

	function onPaymentDisplay(&$order,&$methods,&$usable_methods)
	{
    	if(!empty($methods)){
    		foreach($methods as $method){
				if($method->payment_type!='idealcheckoutbancontact' || !$method->enabled){
					continue;
				}
				if(!empty($method->payment_zone_namekey)){
					$zoneClass=hikashop::get('class.zone');
	    			$zones = $zoneClass->getOrderZones($order);
					if(!in_array($method->payment_zone_namekey,$zones)){
						return true;
					}
				}
				$currencyClass = hikashop::get('class.currency');
				$null=null;
				if(!empty($order->total)){
					$currency_id = intval(@$order->total->prices[0]->price_currency_id);
					$currency = $currencyClass->getCurrencies($currency_id,$null);
					if(!empty($currency) && !in_array(@$currency[$currency_id]->currency_code,$this->accepted_currencies)){
						return true;
					}
				}
				$usable_methods[$method->ordering]=$method;
    		}
    	}
    	return true;
    }

	function onPaymentSave(&$cart,&$rates,&$payment_id)
	{
    	$usable = array();
    	$this->onPaymentDisplay($cart,$rates,$usable); 
    	$payment_id = (int) $payment_id;
    	foreach($usable as $usable_method){
    		if($usable_method->payment_id==$payment_id){
    			return $usable_method;
    		}
    	}
    	return false;
    }

	function onAfterOrderConfirm(&$order,&$methods,$method_id)
	{
		$method =& $methods[$method_id];
		$tax_total = '';
		$discount_total = '';
		$currencyClass = hikashop::get('class.currency');
		$currencies=null;
		$currencies = $currencyClass->getCurrencies($order->order_currency_id,$currencies);
		$currency=$currencies[$order->order_currency_id];
		$user = hikashop::loadUser(true);
		$lang = &JFactory::getLanguage();
		$locale=strtolower(substr($lang->get('tag'),0,2));



		// Calculate total price
		$vars = array();
		$i = 1;
		$tax = 0;
		$total = 0;

		$aProductsInCart = array();

		foreach($order->cart->products as $product)
		{
			$vars["item_name_".$i]=substr($product->order_product_name,0,127);
			$vars["item_number_".$i]=$product->order_product_code;
			$vars["amount_".$i]=round($product->order_product_price,(int)$currency->currency_locale['int_frac_digits']);
			$vars["quantity_".$i]=$product->order_product_quantity;

			$aProductsInCart[$product->product_id] = $product->order_product_quantity;

			$tax+=round($product->order_product_tax,(int)$currency->currency_locale['int_frac_digits'])*$product->order_product_quantity;
			$total += round($product->order_product_price,(int)$currency->currency_locale['int_frac_digits'])*$product->order_product_quantity;

			$i++;
		}

		if(bccomp($tax,0,5)){
			$vars['tax_cart']=$tax;
			$total += round($tax,(int)$currency->currency_locale['int_frac_digits']);
		}

		if(!empty($order->order_shipping_price)){
			$vars["item_name_".$i]=JText::_('HIKASHOP_SHIPPING');
			$vars["amount_".$i]=round($order->order_shipping_price,(int)$currency->currency_locale['int_frac_digits']);
			$vars["quantity_".$i]=1;

			$total += round($order->order_shipping_price,(int)$currency->currency_locale['int_frac_digits']);
			$i++;
		}

		if(!empty($order->cart->coupon)){
			$vars["discount_amount_cart"]=round($order->cart->coupon->discount_value,(int)$currency->currency_locale['int_frac_digits']);
			$total -= round($order->cart->coupon->discount_value,(int)$currency->currency_locale['int_frac_digits']);
		}


		// Load gateway settings
		require_once(JPATH_ROOT . '/idealcheckout/includes/library.php');


		// Create transaction record
		$aDatabaseSettings = idealcheckout_getDatabaseSettings();

		$sStoreCode = idealcheckout_getStoreCode();
		$sGatewayCode = 'bancontact';
		$sLanguageCode = 'nl'; // nl, de, en
		$sCountryCode = '';
		$sCurrencyCode = 'EUR';

		$sOrderId = $order->order_id;
		$sOrderCode = idealcheckout_getRandomCode(32);
		$aOrderParams = array('cart' => $aProductsInCart);
		$sTransactionId = idealcheckout_getRandomCode(32);
		$sTransactionCode = idealcheckout_getRandomCode(32);
		$fTransactionAmount = round($total, 2);
		$sTransactionDescription = idealcheckout_getTranslation($sLanguageCode, 'idealcheckout', 'Webshop order #{0}', array($sOrderId));
		$sTransactionPaymentUrl = ''; // HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id=' . $sOrderId;
		$sTransactionSuccessUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutbancontact&tmpl=component&lang=' . $locale;
		$sTransactionPendingUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutbancontact&tmpl=component&lang=' . $locale;
		$sTransactionFailureUrl = HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=notify&order_id=' . $sOrderId . '&order_code=' . $sOrderCode . '&notif_payment=idealcheckoutbancontact&tmpl=component&lang=' . $locale;
		$aTransactionParams = array();


		$sql = "INSERT INTO `" . $aDatabaseSettings['table'] . "` SET 
`id` = NULL, 
`order_id` = '" . idealcheckout_escapeSql($sOrderId) . "', 
`order_code` = '" . idealcheckout_escapeSql($sOrderCode) . "', 
`order_params` = '" . idealcheckout_escapeSql(idealcheckout_serialize($aOrderParams)) . "', 
`store_code` = " . (empty($sStoreCode) ? "NULL" : "'" . idealcheckout_escapeSql($sStoreCode) . "'") . ", 
`gateway_code` = '" . idealcheckout_escapeSql($sGatewayCode) . "', 
`language_code` = " . (empty($sLanguageCode) ? "NULL" : "'" . idealcheckout_escapeSql($sLanguageCode) . "'") . ", 
`country_code` = " . (empty($sCountryCode) ? "NULL" : "'" . idealcheckout_escapeSql($sCountryCode) . "'") . ", 
`currency_code` = '" . idealcheckout_escapeSql($sCurrencyCode) . "', 
`transaction_id` = '" . idealcheckout_escapeSql($sTransactionId) . "', 
`transaction_code` = '" . idealcheckout_escapeSql($sTransactionCode) . "', 
`transaction_params` = NULL, 
`transaction_date` = '" . idealcheckout_escapeSql(time()) . "', 
`transaction_amount` = '" . idealcheckout_escapeSql($fTransactionAmount) . "', 
`transaction_description` = '" . idealcheckout_escapeSql($sTransactionDescription) . "', 
`transaction_status` = NULL, 
`transaction_url` = NULL, 
`transaction_payment_url` = '" . idealcheckout_escapeSql($sTransactionPaymentUrl) . "', 
`transaction_success_url` = '" . idealcheckout_escapeSql($sTransactionSuccessUrl) . "', 
`transaction_pending_url` = '" . idealcheckout_escapeSql($sTransactionPendingUrl) . "', 
`transaction_failure_url` = '" . idealcheckout_escapeSql($sTransactionFailureUrl) . "', 
`transaction_log` = NULL;";

		$db = & JFactory::getDBO();
		$db->setQuery($sql);
		$db->query();

		// Set URL to /idealcheckout/setup.php
		define('IDEAL_SETUP_URL', HIKASHOP_LIVE . 'idealcheckout/setup.php?order_id=' . $sOrderId . '&order_code=' . $sOrderCode);

		if(HIKASHOP_J3) 
		{
			JHTML::_('behavior.framework');
		}
		else
		{
			JHTML::_('behavior.mootools');
		}

		$app =& JFactory::getApplication();
		$name = $method->payment_type.'_end.php';
    	$path = JPATH_THEMES.DS.$app->getTemplate().DS.'hikashoppayment'.DS.$name;
    	if(!file_exists($path)){
    		if(version_compare(JVERSION,'1.6','<')){
    			$path = JPATH_PLUGINS .DS.'hikashoppayment'.DS.$name;
    		}else{
    			$path = JPATH_PLUGINS .DS.'hikashoppayment'.DS.$method->payment_type.DS.$name;
    		}

			if(!file_exists($path)){
    			return true;
    		}
    	}

		require($path);
    	return true;
    }

	function onPaymentNotification(&$statuses)
	{
		$pluginsClass = hikashop::get('class.plugins');
		$elements = $pluginsClass->getMethods('payment','idealcheckoutbancontact');
		if(empty($elements)) return false;
		$element = reset($elements);
		if(empty($_GET['order_id'])) return false;

		$order_id = intval($_GET['order_id']);
		$order_code = $_GET['order_code'];

		// Load gateway settings
		require_once(JPATH_ROOT . '/idealcheckout/includes/library.php');

		// Get payment status
		$aDatabaseSettings = idealcheckout_getDatabaseSettings();
		$sql = "SELECT `transaction_id` AS `id`, `transaction_status` AS `status`, `transaction_amount` AS `amount`, `transaction_params` AS `params` FROM `" . $aDatabaseSettings['table'] . "` WHERE (`order_id` = '" . idealcheckout_escapeSql($order_id) . "') AND (`order_code` = '" . idealcheckout_escapeSql($order_code) . "') LIMIT 1;";

		$aTransaction = idealcheckout_database_getRecord($sql);

		$data = array();

		$orderClass = hikashop::get('class.order');
		$dbOrder = $orderClass->get($order_id);

		if(empty($dbOrder)){
			echo "Could not load any order for your notification " . $order_id;
			return false;
		}

		$order = null;
		$order->order_id = $dbOrder->order_id;
		$order->old_status->order_status = $dbOrder->order_status;
		$url = HIKASHOP_LIVE.'administrator/index.php?option=com_hikashop&ctrl=order&task=edit&order_id='.$order->order_id;

		$order_text = "\r\n".JText::sprintf('NOTIFICATION_OF_ORDER_ON_WEBSITE',hikashop::encode($dbOrder),HIKASHOP_LIVE);
		$order_text .= "\r\n".str_replace('<br/>',"\r\n",JText::sprintf('ACCESS_ORDER_WITH_LINK',$url));


		$order->history->history_reason = JText::sprintf('AUTOMATIC_PAYMENT_NOTIFICATION');
		$order->history->history_notified = 0;
		$order->history->history_amount = $aTransaction['amount'];
		$order->history->history_payment_id = $aTransaction['id'];
		$order->history->history_payment_method = 'idealcheckoutbancontact';
		$order->history->history_data = ob_get_clean();
		$order->history->history_type = 'payment';

		$currencyClass = hikashop::get('class.currency');
		$currencies=null;
		$currencies = $currencyClass->getCurrencies($dbOrder->order_currency_id,$currencies);
		$currency=$currencies[$dbOrder->order_currency_id];

		if(in_array($aTransaction['status'], array('SUCCESS', 'PENDING')))
		{
			if(in_array($aTransaction['status'], array('SUCCESS')))
			{
				$order->order_status = $element->payment_params->verified_status;
				$order->history->history_notified=1;
			}
			else
			{
				$order->order_status = $element->payment_params->pending_status;
				$order_text = JText::sprintf('CHECK_DOCUMENTATION',HIKASHOP_HELPURL.'payment-idealcheckoutbancontact-error#pending')."\r\n\r\n".$order_text;
			}


			// Send mail
			$mailer =& JFactory::getMailer();
			$config =& hikashop::config();
			$sender = array( 
				$config->get('from_email'),
				$config->get('from_name') );
			$mailer->setSender($sender);
			$mailer->addRecipient(explode(',',$config->get('payment_notification_email')));

			$order->mail_status=$statuses[$order->order_status];
			$mailer->setSubject(JText::sprintf('PAYMENT_NOTIFICATION','Bancontact',$aTransaction['status']));
			$body = str_replace('<br/>',"\r\n",JText::sprintf('PAYMENT_NOTIFICATION_STATUS','Bancontact',$aTransaction['status'])).' '.JText::sprintf('ORDER_STATUS_CHANGED',$order->mail_status)."\r\n\r\n".$order_text;
			$mailer->setBody($body);
			$mailer->Send();

			$orderClass->save($order);
		
			header('Location: ' . HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id=' . $order_id);
			echo '<form method="post" action="' . htmlspecialchars(HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id=' . $order_id) . '" name="idealcheckout_form" id="idealcheckout_form"><script type="text/javascript"> function idealcheckout_redirect() { document.idealcheckout_form.submit(); } setTimeout(\'idealcheckout_redirect()\', 1000); </script></form>';
		}
		else
		{
			$order->order_status = $element->payment_params->invalid_status;

			// Try to restore cart
			$cartClass = hikashop::get('class.cart');

			if($aTransaction['params'])
			{
				$aTransactionParams = idealcheckout_unserialize($aTransaction['params']);

				if(isset($aTransactionParams['cart']) && is_array($aTransactionParams['cart']))
				{
					foreach($aTransactionParams['cart'] as $k => $v)
					{
						$cartClass->update($k, $v);
					}
				}
			}

			$orderClass->save($order);

			header('Location: ' . HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id=' . $order_id);
			echo '<form method="post" action="' . htmlspecialchars(HIKASHOP_LIVE . 'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id=' . $order_id) . '" name="idealcheckout_form" id="idealcheckout_form"><script type="text/javascript"> function idealcheckout_redirect() { document.idealcheckout_form.submit(); } setTimeout(\'idealcheckout_redirect()\', 1000); </script></form>';
		}

		return true;
	}

	function onPaymentConfiguration(&$element){

		$this->idealcheckoutbancontact = JRequest::getCmd('name','Bancontact'); 

		if(empty($element)){
			$element = null;
			$element->payment_name = 'Bancontact';
			$element->payment_description = 'Betalen met Bancontact.';
			$element->payment_images = 'idealcheckoutbancontact';
			$element->payment_type = $this->idealcheckoutbancontact;
			$element->payment_params = null;
			$list = null;
			$element->payment_params->invalid_status = 'cancelled';
			$element->payment_params->pending_status = 'created';
			$element->payment_params->verified_status = 'confirmed';
			$element = array($element);
		}

		$bar = & JToolBar::getInstance('toolbar');
		JToolBarHelper::save();
		JToolBarHelper::apply();
		JToolBarHelper::cancel();
		JToolBarHelper::divider();
		$bar->appendButton('Pophelp','payment-idealcheckoutbancontact-form');
		hikashop::setTitle('Bancontact','plugin','plugins&plugin_type=payment&task=edit&name='.$this->idealcheckoutbancontact);
		$app =& JFactory::getApplication();
		$app->setUserState(HIKASHOP_COMPONENT.'.payment_plugin_type', $this->idealcheckoutbancontact);
		$this->address = hikashop::get('type.address');
		$this->category = hikashop::get('type.categorysub');
		$this->category->type = 'status';
    }

	function onPaymentConfigurationSave(&$element){
		return true;
    }
}