<?php

	class IDEALCHECKOUT_FOR_LITECART_2_0_2
	{
		// Return the software name
		public static function getSoftwareName()
		{
			return 'Litecart 2.0.2+';
		}



		// Return the software code
		public static function getSoftwareCode()
		{
			return str_replace('_', '-', substr(basename(__FILE__), 0, -4));
		}



		// Return path to main cinfig file (if any)
		public static function getConfigFile()
		{
			return SOFTWARE_PATH . DS . 'includes' . DS . 'config.inc.php';
		}



		// Return path to main cinfig file (if any)
		public static function getConfigData()
		{
			$sConfigFile = self::getConfigFile();

			// Detect DB settings via configuration file
			if(is_file($sConfigFile))
			{
				return file_get_contents($sConfigFile);
			}

			return '';
		}



		// Find default database settings
		public static function getDatabaseSettings($aSettings)
		{
			$aSettings['db_prefix'] = '';
			$sConfigData = self::getConfigData();

			if(!empty($sConfigData))
			{
				$aSettings['db_host'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/define\(\'DB_SERVER\', \'([^\']+)\'\);/');
				$aSettings['db_user'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/define\(\'DB_USERNAME\', \'([^\']+)\'\);/');
				$aSettings['db_pass'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/define\(\'DB_PASSWORD\', \'([^\']+)\'\);/');
				$aSettings['db_name'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/define\(\'DB_DATABASE\', \'([^\']+)\'\);/');
				$aSettings['db_prefix'] = IDEALCHECKOUT_INSTALL::getFileValue($sConfigData, '/define\(\'DB_TABLE_PREFIX\', \'([^\']+)\'\);/');
				$aSettings['db_type'] = (version_compare(PHP_VERSION, '5.3', '>') ? 'mysqli' : 'mysql');
			}

			return $aSettings;
		}



		// See if current software == self::$sSoftwareCode
		public static function isSoftware()
		{
			$aFiles = array();
			$aFiles[] = SOFTWARE_PATH . DS . 'includes' . DS . 'config.inc.php';
			$aFiles[] = SOFTWARE_PATH . DS . 'includes' . DS . 'app_footer.inc.php';
			$aFiles[] = SOFTWARE_PATH . DS . 'includes' . DS . 'app_header.inc.php';

			foreach($aFiles as $sFile)
			{
				if(!is_file($sFile) && !is_dir($sFile))
				{
					return false;
				}
			}

			return true;
		}




		// Install plugin, return text
		public static function doInstall($aSettings)
		{
			IDEALCHECKOUT_INSTALL::doInstall($aSettings);

			$sql = "SHOW COLUMNS FROM `" . $aSettings['db_prefix'] . "idealcheckout_settings` LIKE `webshop_package`";
			
			if(!$aColumn = idealcheckout_database_getRecord($sql))
			{
				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`id` = NULL, 
`keyname` = 'webshop_package',
`value` = 'litecart'";
				idealcheckout_database_execute($sql);
				
			}
			else
			{
				$sql = "UPDATE `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`value` = 'litecart' WHERE (`keyname` = 'webshop_package') LIMIT 1";
				idealcheckout_database_execute($sql);
			}
			
			
			return true;
		}



		// Install plugin, return text
		public static function getInstructions($aSettings)
		{
			$sHtml = '';
			$sHtml .= '<ol>';
			$sHtml .= '<li>Log in op de beheeromgeving van uw webshop.</li>';
			$sHtml .= '<li>Ga naar Modules / Payment.</li>';
			$sHtml .= '<li>Klik rechts bovenin op "Install Module (??)".</li>';
			$sHtml .= '<li>Klik de gewenste betaalmethode aan, en klik op "Install Module".</li>';
			$sHtml .= '<li>Herhaar stap 3 en 4 voor de overige betaalmethoden die u wilt aanbieden in uw webshop.</li>';
			$sHtml .= '</ol>';

			return $sHtml;
		}
	}

?>