<?php

	class IDEALCHECKOUT_FOR_PRESTASHOP_1_7
	{
		// Return the software name
		public static function getSoftwareName()
		{
			return 'Prestashop 1.7+';
		}
		// Return the software code
		public static function getSoftwareCode()
		{
			return str_replace('_', '-', substr(basename(__FILE__), 0, -4));
		}

		// Return the software name
		public static function getSoftwareVersion()
		{
			// Test version
			$aConfigData = self::getConfigData();

			if(sizeof($aConfigData))
			{
				return '1.7';
			}

			return '';
		}


		// Return path to main cinfig file (if any)
		public static function getConfigFile()
		{
			return SOFTWARE_PATH . DS . 'app' . DS . 'config' . DS . 'parameters.php';
		}



		// Return path to main cinfig file (if any)
		public static function getConfigData()
		{
			$sConfigFile = self::getConfigFile();

			// Detect DB settings via configuration file
			if(is_file($sConfigFile))
			{
				return include($sConfigFile);
			}

			return '';
		}



		// Find default database settings
		public static function getDatabaseSettings($aSettings)
		{
			$aSettings['db_prefix'] = 'ps_';
			$aConfigData = self::getConfigData();

			if(sizeof($aConfigData))
			{				
				$aSettings['db_host'] = $aConfigData['parameters']['database_host'];
				$aSettings['db_user'] = $aConfigData['parameters']['database_user'];
				$aSettings['db_pass'] = $aConfigData['parameters']['database_password'];
				$aSettings['db_name'] = $aConfigData['parameters']['database_name'];
				$aSettings['db_prefix'] = $aConfigData['parameters']['database_prefix'];				
				
				$aSettings['db_type'] = (version_compare(PHP_VERSION, '5.3', '>') ? 'mysqli' : 'mysql');
			}

			return $aSettings;
		}



		// See if current software == self::$sSoftwareCode
		public static function isSoftware()
		{
			$aFiles = array();
			$aFiles[] = SOFTWARE_PATH . DS . 'app' . DS . 'config' . DS . 'parameters.php';

			foreach($aFiles as $sFile)
			{
				if(!is_file($sFile) && !is_dir($aFiles))
				{
					return false;
				}
			}

			
			return true;
		}



		// See if write privileges are properly set
		public static function getFilesAndFolders()
		{
			return array();
		}



		// Install plugin, return text
		public static function doInstall($aSettings)
		{
			IDEALCHECKOUT_INSTALL::doInstall($aSettings);

			// Patch files or output instructions
			// Set read/write privileges or output instructions

			$aPaymentMethods = IDEALCHECKOUT_INSTALL::getPaymentMethods();

			foreach($aPaymentMethods as $k => $aPaymentMethod)
			{
				IDEALCHECKOUT_INSTALL::setLog('Creating default configuration settings in database table #_configuration for ' . $aPaymentMethod['code'], __FILE__, __LINE__);

				$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "configuration` WHERE `name` = 'CONF_" . idealcheckout_escapeSql(strtoupper($aPaymentMethod['code'])) . "_FIXED' LIMIT 1;";
				if(!idealcheckout_database_isRecord($sql))
				{
					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "configuration` (`id_configuration`, `id_shop_group`, `id_shop`, `name`, `value`, `date_add`, `date_upd`) VALUES (NULL, NULL, NULL, 'CONF_" . idealcheckout_escapeSql(strtoupper($aPaymentMethod['code'])) . "_FIXED', '0.2', '" . date('Y-m-d H:i:s') . "', '" . date('Y-m-d H:i:s') . "');";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "configuration` (`id_configuration`, `id_shop_group`, `id_shop`, `name`, `value`, `date_add`, `date_upd`) VALUES (NULL, NULL, NULL, 'CONF_" . idealcheckout_escapeSql(strtoupper($aPaymentMethod['code'])) . "_VAR', '2', '" . date('Y-m-d H:i:s') . "', '" . date('Y-m-d H:i:s') . "');";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "configuration` (`id_configuration`, `id_shop_group`, `id_shop`, `name`, `value`, `date_add`, `date_upd`) VALUES (NULL, NULL, NULL, 'CONF_" . idealcheckout_escapeSql(strtoupper($aPaymentMethod['code'])) . "_FIXED_FOREIGN', '0.2', '" . date('Y-m-d H:i:s') . "', '" . date('Y-m-d H:i:s') . "');";
					idealcheckout_database_execute($sql);

					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "configuration` (`id_configuration`, `id_shop_group`, `id_shop`, `name`, `value`, `date_add`, `date_upd`) VALUES (NULL, NULL, NULL, 'CONF_" . idealcheckout_escapeSql(strtoupper($aPaymentMethod['code'])) . "_VAR_FOREIGN', '2', '" . date('Y-m-d H:i:s') . "', '" . date('Y-m-d H:i:s') . "');";
					idealcheckout_database_execute($sql);
				}

				$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "module` WHERE `name` = '" . idealcheckout_escapeSql($aPaymentMethod['code']) . "' LIMIT 1;";
				if(!idealcheckout_database_isRecord($sql))
				{
					$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "module` (`id_module`, `name`, `active`, `version`) VALUES (NULL, '" . idealcheckout_escapeSql($aPaymentMethod['code']) . "', 1, '0.5');";
					idealcheckout_database_execute($sql);
				}
			}


			// Add orderstatus "Payment Pending"
			IDEALCHECKOUT_INSTALL::setLog('Adding order state "pending".', __FILE__, __LINE__);

			$sql = "SELECT * FROM `" . $aSettings['db_prefix'] . "order_state` WHERE (`id_order_state` = '1000') LIMIT 1;";
			if(!idealcheckout_database_isRecord($sql))
			{
				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "order_state` SET `id_order_state` = '1000', `invoice` = '1', `send_email` = '0', `color` = 'lightblue', `unremovable` = '1', `hidden` = '0', `logable` = '0', `delivery` = '0', `deleted` = '0';";
				idealcheckout_database_execute($sql);

				// Find languages
				$sql = "SELECT `id_lang`, `iso_code` FROM `" . $aSettings['db_prefix'] . "lang` ORDER BY `id_lang` ASC;";
				$rsLanguages = idealcheckout_database_getRecords($sql);

				foreach($rsLanguages as $aLanguage)
				{
					if(strcmp($aLanguage['iso_code'], 'nl') === 0)
					{
						$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "order_state_lang` SET `id_order_state` = '1000', `id_lang` = '" . $aLanguage['id_lang'] . "', `name` = 'Wacht op betaling', `template` = 'payment';";
						idealcheckout_database_execute($sql);
					}
					else
					{
						$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "order_state_lang` SET `id_order_state` = '1000', `id_lang` = '" . $aLanguage['id_lang'] . "', `name` = 'Awaiting payment', `template` = 'payment';";
						idealcheckout_database_execute($sql);
					}
				}
			}

			
			$sql = "SHOW COLUMNS FROM `" . $aSettings['db_prefix'] . "idealcheckout_settings` LIKE `webshop_package`";
			
			if(!$aColumn = idealcheckout_database_getRecord($sql))
			{
				$sql = "INSERT INTO `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`id` = NULL, 
`keyname` = 'webshop_package',
`value` = 'prestashop'";
				idealcheckout_database_execute($sql);
				
			}
			else
			{
				$sql = "UPDATE `" . $aSettings['db_prefix'] . "idealcheckout_settings` SET
`value` = 'prestashop' WHERE (`keyname` = 'webshop_package') LIMIT 1";
				idealcheckout_database_execute($sql);
			}
			
			
			
			
			// Additional tips & instructions
			return true;
		}



		// Install plugin, return text
		public static function getInstructions($aSettings)
		{
			$sHtml = '';
			$sHtml .= '<ol>';
			$sHtml .= '<li>Log in op de beheeromgeving van uw webshop.</li>';
			$sHtml .= '<li>Klik in het hoofdmenu op Modules -> Module catalogus en scroll naar beneden.<br>Hier vindt u alle toegevoegde betaalmethoden terug.</li>';
			$sHtml .= '<li>Klik bij elke gewenste betaalmethoden op de knop "install" om de betaalmethode in te schakelen.<br>Mogelijk moet u bevestigen dat uw webshop de plug-in mag vertrouwen.</li>';
			$sHtml .= '</ol>';

			return $sHtml;
		}
	}

?>