<?php

use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if(!defined('_PS_VERSION_')) 
{
    exit;
}

class Idealcheckoutafterpay extends PaymentModule
{
    protected $_html = '';
    protected $_postErrors = array();

    public function __construct()
    {
        $this->name = 'idealcheckoutafterpay';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.0';
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->author = 'iDEAL Checkout';
        $this->controllers = array('validation');
        $this->is_eu_compatible = 1;

        $this->currencies = true;
        $this->currencies_mode = 'checkbox';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('iDEAL Checkout - AfterPay');
        $this->description = $this->l('iDEAL Checkout - AfterPay for Prestashop 1.7+');
    }

    public function install()
    {
        if(!parent::install() || !$this->registerHook('paymentOptions') || !$this->registerHook('paymentReturn')) 
		{
            return false;
        }
		
        return true;
    }

    public function hookPaymentOptions($aParams)
    {
        if(!$this->active) 
		{
            return;
        }

        if(!$this->checkCurrency($aParams['cart'])) 
		{
            return;
        }

        $aPaymentOptions = [
            $this->getIdealcheckoutIdeal(),
        ];

        return $aPaymentOptions;
    }

    public function checkCurrency($oCart)
    {
        $oOrderCurrency = new Currency($oCart->id_currency);
        $oSupportedCurrency = $this->getCurrency($oCart->id_currency);

        if(is_array($oSupportedCurrency)) 
		{
            foreach($oSupportedCurrency as $aModuleCurrency) 
			{
                if($oOrderCurrency->id == $aModuleCurrency['id_currency']) 
				{
                    return true;
                }
            }
        }
        return false;
    }

   
    public function getIdealcheckoutIdeal()
    {
        $oPaymentOption = new PaymentOption();
        $oPaymentOption->setCallToActionText($this->l('AfterPay'))
                       ->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true))
                       ->setInputs([
                            'token' => [
                                'name' =>'token',
                                'type' =>'hidden',
                                'value' =>'12345689',
                            ],
                        ])
                       ->setAdditionalInformation($this->context->smarty->fetch('module:idealcheckoutafterpay/views/templates/front/payment_infos.tpl'))
                       ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_ . $this->name . '/payment.jpg'));

        return $oPaymentOption;
    }

}