<?php

    namespace Opencart\Admin\Controller\Extension\Pph\Payment;

    class PphCreditcard extends \Opencart\System\Engine\Controller {
        public $error = array();
        public $paymentMethod = 'pph_creditcard';

        public function index(): void {
            $this->load->language('extension/pph/payment/' . $this->paymentMethod);

            $this->document->setTitle($this->language->get('heading_title'));

            // Breadcrumb
            $data['breadcrumbs'] = [];

            $data['breadcrumbs'][] = [
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'])
            ];
    
            $data['breadcrumbs'][] = [
                'text' => $this->language->get('text_extension'),
                'href' => $this->url->link('marketplace/opencart/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment')
            ];
    
            $data['breadcrumbs'][] = [
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/pph/payment/' . $this->paymentMethod, 'user_token=' . $this->session->data['user_token'])
            ];
    
            $data['save'] = $this->url->link('extension/pph/payment/' . $this->paymentMethod . '|save', 'user_token=' . $this->session->data['user_token']);
            $data['back'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment');

            // Sandbox Refresh Token
            if (isset($this->request->post['general']['payment_pph_apikey'])) {
                $data['payment_pph_apikey'] = $this->request->post['general']['payment_pph_apikey'];
            } else {
                $data['payment_pph_apikey'] = $this->config->get('payment_pph_apikey');
            }

            $this->load->model('localisation/order_status');
            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
    
            // Status success
            if(isset($this->request->post['general']['payment_pph_status_success'])) {
                $data['payment_pph_status_success'] = $this->request->post['general']['payment_pph_status_success'];
            } else {
                $data['payment_pph_status_success'] = $this->config->get('payment_pph_status_success');
            }

            // Status pending
            if (isset($this->request->post['general']['payment_pph_status_pending'])) {
                $data['payment_pph_status_pending'] = $this->request->post['general']['payment_pph_status_pending'];
            } else {
                $data['payment_pph_status_pending'] = $this->config->get('payment_pph_status_pending');
            }
    
            // Status cancelled
            if (isset($this->request->post['general']['payment_pph_status_cancelled'])) {
                $data['payment_pph_status_cancelled'] = $this->request->post['general']['payment_pph_status_cancelled'];
            } else {
                $data['payment_pph_status_cancelled'] = $this->config->get('payment_pph_status_cancelled');
    
                if (empty($data['payment_pph_status_cancelled'])) {
                    $data['payment_pph_status_cancelled'] = 7;
                }
            }

            // Enabled?
            if (isset($this->request->post['method']['payment_' . $this->paymentMethod . '_status'])) {
                $data['payment_' . $this->paymentMethod . '_status'] = $this->request->post['method']['payment_' . $this->paymentMethod . '_status'];
            } else {
                $data['payment_' . $this->paymentMethod . '_status'] = $this->config->get('payment_' . $this->paymentMethod . '_status');
            }

            // Sort order
            if (isset($this->request->post['method']['payment_' . $this->paymentMethod . '_sort_order'])) {
                $data['payment_' . $this->paymentMethod . '_sort_order'] = $this->request->post['method']['payment_' . $this->paymentMethod . '_sort_order'];
            } else {
                $data['payment_' . $this->paymentMethod . '_sort_order'] = $this->config->get('payment_' . $this->paymentMethod . '_sort_order');
            }

            // Default components
            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');
    
            $this->response->setOutput($this->load->view('extension/pph/payment/' . $this->paymentMethod, $data));
        }
    

        public function save(): void {
            $this->load->language('extension/pph/payment/' . $this->paymentMethod);
    
            $json = [];
    
            if (!$this->user->hasPermission('modify', 'extension/pph/payment/' . $this->paymentMethod)) {
                $json['error']['warning'] = $this->language->get('error_permission');
            }

            if (!@$this->request->post['general']['payment_pph_apikey']) {
                $json['error']['warning'] = $this->language->get('payment_pph_apikey');
            }
    
            if (!$json) {
                $this->load->model('setting/setting');
    
                $this->model_setting_setting->editSetting('payment_pph', $this->request->post['general']);
			    $this->model_setting_setting->editSetting('payment_' . $this->paymentMethod, $this->request->post['method']);

                $json['success'] = $this->language->get('text_success');
            }
    
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode($json));
        }
    }

?>