<?php

namespace Opencart\Catalog\Model\Extension\Ppp\Payment;

class PppIdeal extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/ppp/payment/ppp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['ppp_ideal'] = [
                'code' => 'ppp_ideal.ppp_ideal',
                'name' => $this->language->get('heading_title_ppp_ideal'),
            ];

            $method_data = [
                'code' => 'ppp_ideal',
                'name' => $this->language->get('heading_title_ppp_ideal'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_ppp_ideal_sort_order'),
            ];
        }

        return $method_data;
    }
}
