<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppAfterpay extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_afterpay'] = [
                'code' => 'rpp_afterpay.rpp_afterpay',
                'name' => $this->language->get('heading_title_rpp_afterpay'),
            ];

            $method_data = [
                'code' => 'rpp_afterpay',
                'name' => $this->language->get('heading_title_rpp_afterpay'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_afterpay_sort_order'),
            ];
        }

        return $method_data;
    }
}
