<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppBancontact extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_bancontact'] = [
                'code' => 'rpp_bancontact.rpp_bancontact',
                'name' => $this->language->get('heading_title_rpp_bancontact'),
            ];

            $method_data = [
                'code' => 'rpp_bancontact',
                'name' => $this->language->get('heading_title_rpp_bancontact'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_bancontact_sort_order'),
            ];
        }

        return $method_data;
    }
}
