<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppCreditcard extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_creditcard'] = [
                'code' => 'rpp_creditcard.rpp_creditcard',
                'name' => $this->language->get('heading_title_rpp_creditcard'),
            ];

            $method_data = [
                'code' => 'rpp_creditcard',
                'name' => $this->language->get('heading_title_rpp_creditcard'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_creditcard_sort_order'),
            ];
        }

        return $method_data;
    }
}
