<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppIdeal extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_ideal'] = [
                'code' => 'rpp_ideal.rpp_ideal',
                'name' => $this->language->get('heading_title_rpp_ideal'),
            ];

            $method_data = [
                'code' => 'rpp_ideal',
                'name' => $this->language->get('heading_title_rpp_ideal'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_ideal_sort_order'),
            ];
        }

        return $method_data;
    }
}
