<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppMaestro extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_maestro'] = [
                'code' => 'rpp_maestro.rpp_maestro',
                'name' => $this->language->get('heading_title_rpp_maestro'),
            ];

            $method_data = [
                'code' => 'rpp_maestro',
                'name' => $this->language->get('heading_title_rpp_maestro'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_maestro_sort_order'),
            ];
        }

        return $method_data;
    }
}
