<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppMastercard extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_mastercard'] = [
                'code' => 'rpp_mastercard.rpp_mastercard',
                'name' => $this->language->get('heading_title_rpp_mastercard'),
            ];

            $method_data = [
                'code' => 'rpp_mastercard',
                'name' => $this->language->get('heading_title_rpp_mastercard'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_mastercard_sort_order'),
            ];
        }

        return $method_data;
    }
}
