<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppPaypal extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_paypal'] = [
                'code' => 'rpp_paypal.rpp_paypal',
                'name' => $this->language->get('heading_title_rpp_paypal'),
            ];

            $method_data = [
                'code' => 'rpp_paypal',
                'name' => $this->language->get('heading_title_rpp_paypal'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_paypal_sort_order'),
            ];
        }

        return $method_data;
    }
}
