<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppSofort extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_sofort'] = [
                'code' => 'rpp_sofort.rpp_sofort',
                'name' => $this->language->get('heading_title_rpp_sofort'),
            ];

            $method_data = [
                'code' => 'rpp_sofort',
                'name' => $this->language->get('heading_title_rpp_sofort'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_sofort_sort_order'),
            ];
        }

        return $method_data;
    }
}
