<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppVisa extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_visa'] = [
                'code' => 'rpp_visa.rpp_visa',
                'name' => $this->language->get('heading_title_rpp_visa'),
            ];

            $method_data = [
                'code' => 'rpp_visa',
                'name' => $this->language->get('heading_title_rpp_visa'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_visa_sort_order'),
            ];
        }

        return $method_data;
    }
}
