<?php

namespace Opencart\Catalog\Model\Extension\Rpp\Payment;

class RppVpay extends \Opencart\System\Engine\Model
{
    public function getMethods(array $address): array
    {
        $this->load->language('extension/rpp/payment/rpp');

        $status = true;

        $method_data = [];

        if ($status) {
            $option_data['rpp_vpay'] = [
                'code' => 'rpp_vpay.rpp_vpay',
                'name' => $this->language->get('heading_title_rpp_vpay'),
            ];

            $method_data = [
                'code' => 'rpp_vpay',
                'name' => $this->language->get('heading_title_rpp_vpay'),
                'option' => $option_data,
                'sort_order' => $this->config->get('payment_rpp_vpay_sort_order'),
            ];
        }

        return $method_data;
    }
}
