<?php

    class rppbase
    {
        public function __construct()
		{
			$this->id = $this->getClass();
            $this->name = $this->getName();
            $this->description = '';
            $this->author = 'iDEAL Checkout';
            $this->version = '1.0.1';
            $this->website = 'https://www.ideal-checkout.nl';
            $this->priority = 0;
        }

        public function getClass()
		{
			throw new Exception('Forgot the getClass method for this payment method?');
		}

		public function getName()
		{
			throw new Exception('Forgot the getName method for this payment method?');
		}

        public function getCode()
        {
			throw new Exception('Forgot the getCode method for this payment method?');
        }

        // Backend settings page
        public function settings()
		{
			return [
                [
                    'key' => 'status',
                    'default_value' => '1',
                    'title' => language::translate($this->getClass() . ':title_status', 'Status'),
                    'description' => language::translate($this->getClass() . ':description_status', 'Enable or Disable the payment method'),
                    'function' => 'toggle("e/d")',
                ],
                [
                    'key' => 'apikey',
                    'default_value' => '',
                    'title' => language::translate($this->getClass() . ':title_apikey', 'API Key'),
                    'description' => language::translate($this->getClass() . ':description_apikey', 'RPP API key for this shop'),
                    'function' => 'textarea()',
                ],
				[
                    'key' => 'icon',
                    'default_value' => '/images/payment/' . $this->getClass() . '.png',
                    'title' => language::translate($this->getClass() . ':title_icon', 'Icon'),
                    'description' => language::translate($this->getClass() . ':description_icon', 'Path to desired icon'),
                    'function' => 'input()',
                ],
                [
                  'key' => 'success_order_status_id',
                  'default_value' => '0',
                  'title' => language::translate('title_paid_order_status', 'Paid Order Status'),
                  'description' => language::translate('modules:description_order_status', 'Give paid orders made with this payment method the following order status.'),
                  'function' => 'order_status()',
                ],
                [
                  'key' => 'pending_order_status_id',
                  'default_value' => '0',
                  'title' => language::translate('title_pending_order_status', 'Pending Order Status'),
                  'description' => language::translate('modules:description_order_status', 'Give pending orders made with this payment method the following order status.'),
                  'function' => 'order_status()',
                ],
                [
                  'key' => 'geo_zones',
                  'default_value' => '',
                  'title' => language::translate('title_geo_zone_limitation', 'Geo Zone Limitation'),
                  'description' => language::translate('modules:description_geo_zone', 'Limit this module to the selected geo zone. Otherwise leave blank.'),
                  'function' => 'geo_zone()',
                ],
                [
                  'key' => 'priority',
                  'default_value' => '0',
                  'title' => language::translate('title_priority', 'Priority'),
                  'description' => language::translate('modules:description_priority', 'Process this module in the given priority order.'),
                  'function' => 'number()',
                ],

            ];
        }

        // Options in the checkout
         /*
        * Return selectable payment options for checkout
        */
        public function options($items, $subtotal, $tax, $currency_code, $customer)
        {
            // If not enabled
            if(empty($this->settings['status'])) 
            {
                return;
            }

            if(!empty($this->settings['geo_zone_id'])) 
            {
                if(functions::reference_in_geo_zone($this->settings['geo_zone_id'], $customer['country_code'], $customer['zone_code']) != true)
                {
                   return;
                } 
            }

            $method = [
                'title' => $this->name,
                'description' => language::translate($this->getClass() . ':description', ''),
                'options' => [
                    [
                        'id' => $this->id,
                        'icon' => $this->settings['icon'],
                        'name' => $this->name,
                        'description' => language::translate($this->getClass() . ':description'),
                        'fields' => '',
                        'cost' => '',
                        'tax_class_id' => '',
                        'confirm' => language::translate($this->getClass() . ':title_confirm_order', 'Confirm Order'),
                    ],
                ]
            ];

            return $method;
        }

        public function transfer($order) // Collect order data and execute payment
		{
			if(empty($order))
			{
				global $order;
			}

			$orderId = $order->data['uid'];
			$orderNumber = $order->data['uid'];
            $description = 'Order ' . $orderNumber;
            $amount = round(str_replace(',', '', $order->data['payment_due'] * $order->data['currency_value']), 2);
            $paymentCode = $this->getCode();
            $currencyCode = $order->data['currency_code'];
            $languageCode = $order->data['language_code'];

            if(!empty($_SERVER['HTTP_CLIENT_IP'])) 
            {
                $customerIp = $_SERVER['HTTP_CLIENT_IP'];
            } 
            elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) 
            {
                $customerIp = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } 
            else 
            {
                $customerIp = $_SERVER['REMOTE_ADDR']; 
            }

            $returnUrl = document::ilink('order_process');
            $notifyUrl = $returnUrl;

            $rpp = new RppPayment($this->settings['apikey']);

            $rpp->setOrder($orderId, $orderNumber, $description);
            $rpp->setOrderAmount($amount);
            $rpp->setCurrencyCode($currencyCode);
            $rpp->setLanguageCode($languageCode);
            $rpp->setPaymentMethod($paymentCode);
            $rpp->setReturnUrl($returnUrl);
            $rpp->setReportUrl($notifyUrl);
            $rpp->setCustomerIp($customerIp);

            $customer = [];
            $customer['first_name'] = $order->data['customer']['firstname'];
            $customer['last_name'] = $order->data['customer']['lastname'];
            $customer['email'] = $order->data['customer']['email'];
            $rpp->setCustomerData($customer);

            $rpp->setAccessToken();

            if($rpp->setTransaction()) 
            {
                if($redirectUrl = $rpp->getTransactionUrl())
                {
                    return [
                        'action' => $redirectUrl,
                        'method' => 'get',
                    ];
                }
                else
                {
                    // No URL received, so there must be something wrong
                    $error = $rpp->getError();

                    return [
                        'error' => $error['message']
                    ];
                }
            }
            else 
            {
                // No URL received, so there must be something wrong
                $error = $rpp->getError();

                return [
                    'error' => $error['message']
                ];
            }
        }
        
        
        
        public function verify($order) // Return from gateway
		{
            if(empty($_GET['order_number']) && empty($_GET['order_code']) && empty($_GET['payment_job']) && empty($_GET['signature']))
            {
                // Required parameters missing
                return array('error' => 'There was an error verifying your transaction');
            }
            else
            {
                $rpp = new RppPayment($this->settings['apikey']);
                $rpp->setAccessToken();
    
                if($validRequest = $rpp->checkReturn($_GET))
                {
                    $orderId = $_GET['order_number'];
                    $paymentJob = $_GET['payment_job'];

                    $status = $rpp->getStatus($paymentJob);

                    $successStatus = $this->settings['success_order_status_id'];
                    $pendingStatus = $this->settings['pending_order_status_id'];
                    $cancelStatus = $this->settings['cancel_order_status_id'];

                    // New or pending orders can be changed
                    if(in_array($order->data['order_status_id'], array('0', $pendingStatus)))
                    {
                        if(strcmp($status, 'SUCCESS') === 0)
                        {
                            $order->save(); // Save order to database

                            return array(
                                'order_status_id' => $successStatus,
                                'payment_transaction_id' => $paymentJob,
                                'transaction_id' => $paymentJob,
                                'errors' => '',
                            );
                        }
                        elseif(strcmp($status, 'PENDING') === 0)
                        {
                            return array(
                                'order_status_id' => $pendingStatus,
                                'payment_transaction_id' => $paymentJob,
                                'transaction_id' => $paymentJob,
                                'errors' => '',
                            );
                        }
                        else
                        {
                            $url = document::ilink('checkout');

                            header('Location: ' . $url);
                            exit;
                        }
                    }
                }
            }
        }
    }

?>